% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_uncertainty.R
\name{estimate_uncertainty}
\alias{estimate_uncertainty}
\alias{estimate_uncertainty.glm}
\alias{estimate_uncertainty.lgmr}
\title{Estimate measurement uncertainty}
\usage{
estimate_uncertainty(reg, data, id_col, design_matrix)

\method{estimate_uncertainty}{glm}(reg, data, id_col, design_matrix)

\method{estimate_uncertainty}{lgmr}(reg, data, id_col, design_matrix)
}
\arguments{
\item{reg}{A \code{glm} gamma regression or \code{lgmr} object}

\item{data}{A \code{tibble} or \code{data.frame}}

\item{id_col}{A character for the name of the column containing the
name of the features in data (e.g., peptides, proteins, etc.)}

\item{design_matrix}{Cell mean design matrix for the data}
}
\value{
A matrix with the uncertainty
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Estimates the measurement uncertainty for each data point using
a Gamma regression.
Calculated as the expected standard deviation for each measurement:
\deqn{
     \text{E}[s_i|\omega,y_{ij}]=\exp({f(y_{ij},\omega)})
  }
where \eqn{\omega} are the regression parameters and \eqn{f} is a function
describing the mean relationship between \eqn{s_i} and \eqn{y_{ij}}.
}
\examples{
# Setup model matrix
design <- model.matrix(~ 0 + factor(rep(1:2, each = 3)))
colnames(design) <- paste0("ng", c(50, 100))

yeast_norm <- yeast \%>\%
  # Remove missing data
  tidyr::drop_na() \%>\%
  # Normalize data
  psrn("identifier") \%>\%
  # Add mean-variance trends
  calculate_mean_sd_trends(design)
# Fit the gamma regression
gam <- fit_gamma_regression(yeast_norm, sd ~ mean)
# Estimate each data point's uncertainty
estimate_uncertainty(gam, yeast_norm, 'identifier', design)
}
