// Generated by rstantools.  Do not edit by hand.

/*
    baggr is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    baggr is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with baggr.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-1-g67504470
#include <stan/model/model_header.hpp>
namespace model_mutau_full_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 72, column 2 to column 82)",
                                                      " (in 'string', line 73, column 2 to column 48)",
                                                      " (in 'string', line 74, column 2 to column 34)",
                                                      " (in 'string', line 75, column 2 to column 37)",
                                                      " (in 'string', line 76, column 2 to column 18)",
                                                      " (in 'string', line 78, column 2 to column 31)",
                                                      " (in 'string', line 81, column 2 to column 41)",
                                                      " (in 'string', line 82, column 2 to column 37)",
                                                      " (in 'string', line 84, column 4 to column 24)",
                                                      " (in 'string', line 83, column 2 to line 84, column 24)",
                                                      " (in 'string', line 89, column 6 to column 39)",
                                                      " (in 'string', line 87, column 6 to column 57)",
                                                      " (in 'string', line 86, column 4 to line 89, column 39)",
                                                      " (in 'string', line 90, column 4 to column 56)",
                                                      " (in 'string', line 85, column 23 to line 91, column 3)",
                                                      " (in 'string', line 85, column 2 to line 91, column 3)",
                                                      " (in 'string', line 139, column 2 to column 25)",
                                                      " (in 'string', line 140, column 2 to column 25)",
                                                      " (in 'string', line 145, column 6 to column 28)",
                                                      " (in 'string', line 143, column 6 to column 40)",
                                                      " (in 'string', line 142, column 4 to line 145, column 28)",
                                                      " (in 'string', line 146, column 4 to column 17)",
                                                      " (in 'string', line 149, column 8 to line 150, column 106)",
                                                      " (in 'string', line 148, column 6 to line 150, column 106)",
                                                      " (in 'string', line 152, column 8 to line 153, column 70)",
                                                      " (in 'string', line 151, column 6 to line 153, column 70)",
                                                      " (in 'string', line 147, column 22 to line 154, column 5)",
                                                      " (in 'string', line 147, column 4 to line 154, column 5)",
                                                      " (in 'string', line 141, column 16 to line 155, column 3)",
                                                      " (in 'string', line 141, column 2 to line 155, column 3)",
                                                      " (in 'string', line 94, column 9 to column 10)",
                                                      " (in 'string', line 94, column 2 to column 19)",
                                                      " (in 'string', line 100, column 6 to column 22)",
                                                      " (in 'string', line 101, column 6 to column 54)",
                                                      " (in 'string', line 99, column 8 to line 102, column 5)",
                                                      " (in 'string', line 98, column 6 to column 34)",
                                                      " (in 'string', line 97, column 4 to line 102, column 5)",
                                                      " (in 'string', line 107, column 6 to column 25)",
                                                      " (in 'string', line 105, column 6 to column 47)",
                                                      " (in 'string', line 104, column 4 to line 107, column 25)",
                                                      " (in 'string', line 112, column 6 to column 37)",
                                                      " (in 'string', line 110, column 6 to column 60)",
                                                      " (in 'string', line 109, column 4 to line 112, column 37)",
                                                      " (in 'string', line 95, column 11 to line 113, column 3)",
                                                      " (in 'string', line 95, column 2 to line 113, column 3)",
                                                      " (in 'string', line 124, column 6 to column 77)",
                                                      " (in 'string', line 123, column 4 to line 124, column 77)",
                                                      " (in 'string', line 122, column 9 to line 125, column 3)",
                                                      " (in 'string', line 117, column 6 to column 72)",
                                                      " (in 'string', line 116, column 4 to line 117, column 72)",
                                                      " (in 'string', line 115, column 22 to line 122, column 3)",
                                                      " (in 'string', line 115, column 2 to line 125, column 3)",
                                                      " (in 'string', line 127, column 4 to column 37)",
                                                      " (in 'string', line 128, column 4 to column 71)",
                                                      " (in 'string', line 129, column 4 to column 74)",
                                                      " (in 'string', line 131, column 6 to column 57)",
                                                      " (in 'string', line 130, column 4 to line 131, column 57)",
                                                      " (in 'string', line 126, column 24 to line 132, column 3)",
                                                      " (in 'string', line 126, column 2 to line 132, column 3)",
                                                      " (in 'string', line 134, column 2 to column 38)",
                                                      " (in 'string', line 24, column 2 to column 17)",
                                                      " (in 'string', line 25, column 2 to column 17)",
                                                      " (in 'string', line 26, column 2 to column 18)",
                                                      " (in 'string', line 27, column 9 to column 10)",
                                                      " (in 'string', line 27, column 11 to column 13)",
                                                      " (in 'string', line 27, column 2 to column 17)",
                                                      " (in 'string', line 28, column 2 to column 19)",
                                                      " (in 'string', line 29, column 2 to column 23)",
                                                      " (in 'string', line 31, column 2 to column 23)",
                                                      " (in 'string', line 32, column 2 to column 27)",
                                                      " (in 'string', line 33, column 28 to column 29)",
                                                      " (in 'string', line 33, column 2 to column 31)",
                                                      " (in 'string', line 34, column 26 to column 27)",
                                                      " (in 'string', line 34, column 2 to column 39)",
                                                      " (in 'string', line 35, column 2 to column 17)",
                                                      " (in 'string', line 38, column 2 to column 26)",
                                                      " (in 'string', line 39, column 9 to column 10)",
                                                      " (in 'string', line 39, column 2 to column 33)",
                                                      " (in 'string', line 40, column 18 to column 19)",
                                                      " (in 'string', line 40, column 21 to column 22)",
                                                      " (in 'string', line 40, column 2 to column 46)",
                                                      " (in 'string', line 46, column 2 to column 24)",
                                                      " (in 'string', line 47, column 2 to column 30)",
                                                      " (in 'string', line 48, column 2 to column 27)",
                                                      " (in 'string', line 49, column 2 to column 33)",
                                                      " (in 'string', line 51, column 2 to column 25)",
                                                      " (in 'string', line 52, column 2 to column 26)",
                                                      " (in 'string', line 54, column 2 to column 21)",
                                                      " (in 'string', line 55, column 2 to column 27)",
                                                      " (in 'string', line 57, column 2 to column 22)",
                                                      " (in 'string', line 58, column 2 to column 22)",
                                                      " (in 'string', line 59, column 9 to column 15)",
                                                      " (in 'string', line 59, column 17 to column 19)",
                                                      " (in 'string', line 59, column 2 to column 28)",
                                                      " (in 'string', line 60, column 34 to column 40)",
                                                      " (in 'string', line 60, column 2 to column 42)",
                                                      " (in 'string', line 61, column 39 to column 45)",
                                                      " (in 'string', line 61, column 2 to column 47)",
                                                      " (in 'string', line 63, column 9 to column 10)",
                                                      " (in 'string', line 63, column 2 to column 14)",
                                                      " (in 'string', line 64, column 9 to column 15)",
                                                      " (in 'string', line 64, column 2 to column 24)",
                                                      " (in 'string', line 65, column 9 to column 15)",
                                                      " (in 'string', line 65, column 2 to column 32)",
                                                      " (in 'string', line 68, column 2 to column 43)",
                                                      " (in 'string', line 72, column 34 to column 80)",
                                                      " (in 'string', line 72, column 23 to column 24)",
                                                      " (in 'string', line 73, column 29 to column 46)",
                                                      " (in 'string', line 73, column 18 to column 19)",
                                                      " (in 'string', line 74, column 15 to column 32)",
                                                      " (in 'string', line 74, column 9 to column 10)",
                                                      " (in 'string', line 75, column 18 to column 35)",
                                                      " (in 'string', line 75, column 9 to column 10)",
                                                      " (in 'string', line 75, column 11 to column 12)",
                                                      " (in 'string', line 76, column 9 to column 11)",
                                                      " (in 'string', line 78, column 18 to column 19)",
                                                      " (in 'string', line 81, column 22 to column 39)",
                                                      " (in 'string', line 81, column 9 to column 10)",
                                                      " (in 'string', line 81, column 11 to column 12)",
                                                      " (in 'string', line 82, column 18 to column 35)",
                                                      " (in 'string', line 82, column 9 to column 10)",
                                                      " (in 'string', line 82, column 11 to column 12)",
                                                      " (in 'string', line 139, column 13 to column 23)",
                                                      " (in 'string', line 140, column 9 to column 15)",
                                                      " (in 'string', line 11, column 9 to column 66)",
                                                      " (in 'string', line 9, column 25 to column 73)",
                                                      " (in 'string', line 9, column 9 to line 11, column 66)",
                                                      " (in 'string', line 6, column 25 to column 70)",
                                                      " (in 'string', line 6, column 9 to line 11, column 66)",
                                                      " (in 'string', line 5, column 25 to column 70)",
                                                      " (in 'string', line 5, column 9 to line 11, column 66)",
                                                      " (in 'string', line 4, column 20 to column 66)",
                                                      " (in 'string', line 4, column 4 to line 11, column 66)",
                                                      " (in 'string', line 3, column 60 to line 12, column 3)",
                                                      " (in 'string', line 20, column 9 to column 66)",
                                                      " (in 'string', line 18, column 25 to column 73)",
                                                      " (in 'string', line 18, column 9 to line 20, column 66)",
                                                      " (in 'string', line 17, column 25 to column 70)",
                                                      " (in 'string', line 17, column 9 to line 20, column 66)",
                                                      " (in 'string', line 16, column 25 to column 70)",
                                                      " (in 'string', line 16, column 9 to line 20, column 66)",
                                                      " (in 'string', line 15, column 20 to column 66)",
                                                      " (in 'string', line 15, column 4 to line 20, column 66)",
                                                      " (in 'string', line 14, column 61 to line 21, column 3)"};
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<T0__,
stan::value_type_t<T2__>>
realprior_lpdf(const T0__& theta, const int& family, const T2__& pars_arg__,
               std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__,
          stan::value_type_t<T2__>>;
  const auto& pars = to_ref(pars_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 133;
    if (logical_eq(family, 0)) {
      current_statement__ = 132;
      return uniform_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
    } else {
      current_statement__ = 131;
      if (logical_eq(family, 1)) {
        current_statement__ = 130;
        return normal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
      } else {
        current_statement__ = 129;
        if (logical_eq(family, 2)) {
          current_statement__ = 128;
          return cauchy_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
        } else {
          current_statement__ = 127;
          if (logical_eq(family, 5)) {
            current_statement__ = 126;
            return lognormal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
          } else {
            current_statement__ = 125;
            return student_t_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)],
                     pars[(3 - 1)]);
          }
        }
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct realprior_lpdf_functor__ {
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<T0__,
stan::value_type_t<T2__>>
operator()(const T0__& theta, const int& family, const T2__& pars,
           std::ostream* pstream__)  const 
{
return realprior_lpdf<propto__>(theta, family, pars, pstream__);
}
};
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T2__>>
vecprior_lpdf(const T0__& theta_arg__, const int& family,
              const T2__& pars_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>,
          stan::value_type_t<T2__>>;
  const auto& theta = to_ref(theta_arg__);
  const auto& pars = to_ref(pars_arg__);
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 143;
    if (logical_eq(family, 0)) {
      current_statement__ = 142;
      return uniform_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
    } else {
      current_statement__ = 141;
      if (logical_eq(family, 1)) {
        current_statement__ = 140;
        return normal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
      } else {
        current_statement__ = 139;
        if (logical_eq(family, 2)) {
          current_statement__ = 138;
          return cauchy_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
        } else {
          current_statement__ = 137;
          if (logical_eq(family, 5)) {
            current_statement__ = 136;
            return lognormal_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)]);
          } else {
            current_statement__ = 135;
            return student_t_lpdf<false>(theta, pars[(1 - 1)], pars[(2 - 1)],
                     pars[(3 - 1)]);
          }
        }
      }
    }
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct vecprior_lpdf_functor__ {
template <bool propto__, typename T0__, typename T2__>
stan::promote_args_t<stan::value_type_t<T0__>,
stan::value_type_t<T2__>>
operator()(const T0__& theta, const int& family, const T2__& pars,
           std::ostream* pstream__)  const 
{
return vecprior_lpdf<propto__>(theta, family, pars, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_mutau_full final : public model_base_crtp<model_mutau_full> {
private:
  int N;
  int K;
  int Nc;
  Eigen::Matrix<double, -1, -1> X;
  int pooling_type;
  int pooling_baseline;
  int joint_prior_mean;
  int joint_prior_variance;
  std::vector<int> site;
  Eigen::Matrix<double, -1, 1> treatment;
  int P;
  int prior_hypermean_fam;
  Eigen::Matrix<double, -1, 1> prior_hypermean_mean;
  Eigen::Matrix<double, -1, -1> prior_hypermean_scale;
  int prior_hypersd_fam;
  Eigen::Matrix<double, -1, 1> prior_hypersd_val;
  int prior_control_sd_fam;
  Eigen::Matrix<double, -1, 1> prior_control_sd_val;
  int prior_hypercor_fam;
  double prior_hypercor_val;
  int prior_beta_fam;
  Eigen::Matrix<double, -1, 1> prior_beta_val;
  int N_test;
  int K_test;
  Eigen::Matrix<double, -1, -1> X_test;
  std::vector<int> test_site;
  std::vector<int> test_treatment;
  Eigen::Matrix<double, -1, 1> y;
  Eigen::Matrix<double, -1, 1> test_y;
  Eigen::Matrix<double, -1, 1> test_sigma_y_k;
  int K_pooled;
  int L_Omega_1dim__;
  int hypersd_1dim__;
  int mu_1dim__;
  int eta_1dim__;
  int theta_k_1dim__;
  int tau_1dim__;
  int logpd_1dim__;
 
public:
  ~model_mutau_full() { }
  
  inline std::string model_name() const final { return "model_mutau_full"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-1-g67504470", "stancflags = "};
  }
  
  
  model_mutau_full(stan::io::var_context& context__,
                   unsigned int random_seed__ = 0,
                   std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_mutau_full_namespace::model_mutau_full";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 61;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 61;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 61;
      current_statement__ = 61;
      check_greater_or_equal(function__, "N", N, 0);
      current_statement__ = 62;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 62;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 62;
      current_statement__ = 62;
      check_greater_or_equal(function__, "K", K, 0);
      current_statement__ = 63;
      context__.validate_dims("data initialization","Nc","int",
          context__.to_vec());
      Nc = std::numeric_limits<int>::min();
      
      current_statement__ = 63;
      Nc = context__.vals_i("Nc")[(1 - 1)];
      current_statement__ = 63;
      current_statement__ = 63;
      check_greater_or_equal(function__, "Nc", Nc, 0);
      current_statement__ = 64;
      validate_non_negative_index("X", "N", N);
      current_statement__ = 65;
      validate_non_negative_index("X", "Nc", Nc);
      current_statement__ = 66;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(N, Nc));
      X = Eigen::Matrix<double, -1, -1>(N, Nc);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 66;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 66;
        pos__ = 1;
        current_statement__ = 66;
        for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
          current_statement__ = 66;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 66;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 66;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 67;
      context__.validate_dims("data initialization","pooling_type","int",
          context__.to_vec());
      pooling_type = std::numeric_limits<int>::min();
      
      current_statement__ = 67;
      pooling_type = context__.vals_i("pooling_type")[(1 - 1)];
      current_statement__ = 68;
      context__.validate_dims("data initialization","pooling_baseline","int",
          context__.to_vec());
      pooling_baseline = std::numeric_limits<int>::min();
      
      current_statement__ = 68;
      pooling_baseline = context__.vals_i("pooling_baseline")[(1 - 1)];
      current_statement__ = 69;
      context__.validate_dims("data initialization","joint_prior_mean","int",
          context__.to_vec());
      joint_prior_mean = std::numeric_limits<int>::min();
      
      current_statement__ = 69;
      joint_prior_mean = context__.vals_i("joint_prior_mean")[(1 - 1)];
      current_statement__ = 70;
      context__.validate_dims("data initialization","joint_prior_variance",
          "int",context__.to_vec());
      joint_prior_variance = std::numeric_limits<int>::min();
      
      current_statement__ = 70;
      joint_prior_variance = context__.vals_i("joint_prior_variance")[
          (1 - 1)];
      current_statement__ = 71;
      validate_non_negative_index("site", "N", N);
      current_statement__ = 72;
      context__.validate_dims("data initialization","site","int",
          context__.to_vec(N));
      site = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 72;
      assign(site, nil_index_list(), context__.vals_i("site"),
        "assigning variable site");
      current_statement__ = 72;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 72;
        current_statement__ = 72;
        check_greater_or_equal(function__, "site[sym1__]",
                               site[(sym1__ - 1)], 0);}
      current_statement__ = 72;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 72;
        current_statement__ = 72;
        check_less_or_equal(function__, "site[sym1__]", site[(sym1__ - 1)], K);
      }
      current_statement__ = 73;
      validate_non_negative_index("treatment", "N", N);
      current_statement__ = 74;
      context__.validate_dims("data initialization","treatment","double",
          context__.to_vec(N));
      treatment = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(treatment, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> treatment_flat__;
        current_statement__ = 74;
        assign(treatment_flat__, nil_index_list(),
          context__.vals_r("treatment"),
          "assigning variable treatment_flat__");
        current_statement__ = 74;
        pos__ = 1;
        current_statement__ = 74;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 74;
          assign(treatment, cons_list(index_uni(sym1__), nil_index_list()),
            treatment_flat__[(pos__ - 1)], "assigning variable treatment");
          current_statement__ = 74;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 74;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 74;
        current_statement__ = 74;
        check_greater_or_equal(function__, "treatment[sym1__]",
                               treatment[(sym1__ - 1)], 0);}
      current_statement__ = 74;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 74;
        current_statement__ = 74;
        check_less_or_equal(function__, "treatment[sym1__]",
                            treatment[(sym1__ - 1)], 1);}
      current_statement__ = 75;
      context__.validate_dims("data initialization","P","int",
          context__.to_vec());
      P = std::numeric_limits<int>::min();
      
      current_statement__ = 75;
      P = context__.vals_i("P")[(1 - 1)];
      current_statement__ = 75;
      current_statement__ = 75;
      check_greater_or_equal(function__, "P", P, 0);
      current_statement__ = 76;
      context__.validate_dims("data initialization","prior_hypermean_fam",
          "int",context__.to_vec());
      prior_hypermean_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 76;
      prior_hypermean_fam = context__.vals_i("prior_hypermean_fam")[(1 - 1)];
      current_statement__ = 77;
      validate_non_negative_index("prior_hypermean_mean", "P", P);
      current_statement__ = 78;
      context__.validate_dims("data initialization","prior_hypermean_mean",
          "double",context__.to_vec(P));
      prior_hypermean_mean = Eigen::Matrix<double, -1, 1>(P);
      stan::math::fill(prior_hypermean_mean, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_hypermean_mean_flat__;
        current_statement__ = 78;
        assign(prior_hypermean_mean_flat__, nil_index_list(),
          context__.vals_r("prior_hypermean_mean"),
          "assigning variable prior_hypermean_mean_flat__");
        current_statement__ = 78;
        pos__ = 1;
        current_statement__ = 78;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 78;
          assign(prior_hypermean_mean,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_hypermean_mean_flat__[(pos__ - 1)],
            "assigning variable prior_hypermean_mean");
          current_statement__ = 78;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 79;
      validate_non_negative_index("prior_hypermean_scale", "P", P);
      current_statement__ = 80;
      validate_non_negative_index("prior_hypermean_scale", "P", P);
      current_statement__ = 81;
      context__.validate_dims("data initialization","prior_hypermean_scale",
          "double",context__.to_vec(P, P));
      prior_hypermean_scale = Eigen::Matrix<double, -1, -1>(P, P);
      stan::math::fill(prior_hypermean_scale, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_hypermean_scale_flat__;
        current_statement__ = 81;
        assign(prior_hypermean_scale_flat__, nil_index_list(),
          context__.vals_r("prior_hypermean_scale"),
          "assigning variable prior_hypermean_scale_flat__");
        current_statement__ = 81;
        pos__ = 1;
        current_statement__ = 81;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 81;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 81;
            assign(prior_hypermean_scale,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              prior_hypermean_scale_flat__[(pos__ - 1)],
              "assigning variable prior_hypermean_scale");
            current_statement__ = 81;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 81;
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        current_statement__ = 81;
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          current_statement__ = 81;
          current_statement__ = 81;
          check_greater_or_equal(function__,
                                 "prior_hypermean_scale[sym1__, sym2__]",
                                 rvalue(prior_hypermean_scale,
                                   cons_list(index_uni(sym1__),
                                     cons_list(index_uni(sym2__),
                                       nil_index_list())),
                                   "prior_hypermean_scale"), 0);}}
      current_statement__ = 82;
      context__.validate_dims("data initialization","prior_hypersd_fam",
          "int",context__.to_vec());
      prior_hypersd_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 82;
      prior_hypersd_fam = context__.vals_i("prior_hypersd_fam")[(1 - 1)];
      current_statement__ = 83;
      context__.validate_dims("data initialization","prior_hypersd_val",
          "double",context__.to_vec(3));
      prior_hypersd_val = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(prior_hypersd_val, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_hypersd_val_flat__;
        current_statement__ = 83;
        assign(prior_hypersd_val_flat__, nil_index_list(),
          context__.vals_r("prior_hypersd_val"),
          "assigning variable prior_hypersd_val_flat__");
        current_statement__ = 83;
        pos__ = 1;
        current_statement__ = 83;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 83;
          assign(prior_hypersd_val,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_hypersd_val_flat__[(pos__ - 1)],
            "assigning variable prior_hypersd_val");
          current_statement__ = 83;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 84;
      context__.validate_dims("data initialization","prior_control_sd_fam",
          "int",context__.to_vec());
      prior_control_sd_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 84;
      prior_control_sd_fam = context__.vals_i("prior_control_sd_fam")[
          (1 - 1)];
      current_statement__ = 85;
      context__.validate_dims("data initialization","prior_control_sd_val",
          "double",context__.to_vec(3));
      prior_control_sd_val = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(prior_control_sd_val, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_control_sd_val_flat__;
        current_statement__ = 85;
        assign(prior_control_sd_val_flat__, nil_index_list(),
          context__.vals_r("prior_control_sd_val"),
          "assigning variable prior_control_sd_val_flat__");
        current_statement__ = 85;
        pos__ = 1;
        current_statement__ = 85;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 85;
          assign(prior_control_sd_val,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_control_sd_val_flat__[(pos__ - 1)],
            "assigning variable prior_control_sd_val");
          current_statement__ = 85;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 86;
      context__.validate_dims("data initialization","prior_hypercor_fam",
          "int",context__.to_vec());
      prior_hypercor_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 86;
      prior_hypercor_fam = context__.vals_i("prior_hypercor_fam")[(1 - 1)];
      current_statement__ = 87;
      context__.validate_dims("data initialization","prior_hypercor_val",
          "double",context__.to_vec());
      prior_hypercor_val = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 87;
      prior_hypercor_val = context__.vals_r("prior_hypercor_val")[(1 - 1)];
      current_statement__ = 88;
      context__.validate_dims("data initialization","prior_beta_fam","int",
          context__.to_vec());
      prior_beta_fam = std::numeric_limits<int>::min();
      
      current_statement__ = 88;
      prior_beta_fam = context__.vals_i("prior_beta_fam")[(1 - 1)];
      current_statement__ = 89;
      context__.validate_dims("data initialization","prior_beta_val",
          "double",context__.to_vec(3));
      prior_beta_val = Eigen::Matrix<double, -1, 1>(3);
      stan::math::fill(prior_beta_val, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> prior_beta_val_flat__;
        current_statement__ = 89;
        assign(prior_beta_val_flat__, nil_index_list(),
          context__.vals_r("prior_beta_val"),
          "assigning variable prior_beta_val_flat__");
        current_statement__ = 89;
        pos__ = 1;
        current_statement__ = 89;
        for (int sym1__ = 1; sym1__ <= 3; ++sym1__) {
          current_statement__ = 89;
          assign(prior_beta_val,
            cons_list(index_uni(sym1__), nil_index_list()),
            prior_beta_val_flat__[(pos__ - 1)],
            "assigning variable prior_beta_val");
          current_statement__ = 89;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 90;
      context__.validate_dims("data initialization","N_test","int",
          context__.to_vec());
      N_test = std::numeric_limits<int>::min();
      
      current_statement__ = 90;
      N_test = context__.vals_i("N_test")[(1 - 1)];
      current_statement__ = 90;
      current_statement__ = 90;
      check_greater_or_equal(function__, "N_test", N_test, 0);
      current_statement__ = 91;
      context__.validate_dims("data initialization","K_test","int",
          context__.to_vec());
      K_test = std::numeric_limits<int>::min();
      
      current_statement__ = 91;
      K_test = context__.vals_i("K_test")[(1 - 1)];
      current_statement__ = 91;
      current_statement__ = 91;
      check_greater_or_equal(function__, "K_test", K_test, 0);
      current_statement__ = 92;
      validate_non_negative_index("X_test", "N_test", N_test);
      current_statement__ = 93;
      validate_non_negative_index("X_test", "Nc", Nc);
      current_statement__ = 94;
      context__.validate_dims("data initialization","X_test","double",
          context__.to_vec(N_test, Nc));
      X_test = Eigen::Matrix<double, -1, -1>(N_test, Nc);
      stan::math::fill(X_test, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_test_flat__;
        current_statement__ = 94;
        assign(X_test_flat__, nil_index_list(), context__.vals_r("X_test"),
          "assigning variable X_test_flat__");
        current_statement__ = 94;
        pos__ = 1;
        current_statement__ = 94;
        for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
          current_statement__ = 94;
          for (int sym2__ = 1; sym2__ <= N_test; ++sym2__) {
            current_statement__ = 94;
            assign(X_test,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_test_flat__[(pos__ - 1)], "assigning variable X_test");
            current_statement__ = 94;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 95;
      validate_non_negative_index("test_site", "N_test", N_test);
      current_statement__ = 96;
      context__.validate_dims("data initialization","test_site","int",
          context__.to_vec(N_test));
      test_site = std::vector<int>(N_test, std::numeric_limits<int>::min());
      
      current_statement__ = 96;
      assign(test_site, nil_index_list(), context__.vals_i("test_site"),
        "assigning variable test_site");
      current_statement__ = 96;
      for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
        current_statement__ = 96;
        current_statement__ = 96;
        check_greater_or_equal(function__, "test_site[sym1__]",
                               test_site[(sym1__ - 1)], 0);}
      current_statement__ = 96;
      for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
        current_statement__ = 96;
        current_statement__ = 96;
        check_less_or_equal(function__, "test_site[sym1__]",
                            test_site[(sym1__ - 1)], K);}
      current_statement__ = 97;
      validate_non_negative_index("test_treatment", "N_test", N_test);
      current_statement__ = 98;
      context__.validate_dims("data initialization","test_treatment","int",
          context__.to_vec(N_test));
      test_treatment = std::vector<int>(N_test, std::numeric_limits<int>::min());
      
      current_statement__ = 98;
      assign(test_treatment, nil_index_list(),
        context__.vals_i("test_treatment"),
        "assigning variable test_treatment");
      current_statement__ = 98;
      for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
        current_statement__ = 98;
        current_statement__ = 98;
        check_greater_or_equal(function__, "test_treatment[sym1__]",
                               test_treatment[(sym1__ - 1)], 0);}
      current_statement__ = 98;
      for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
        current_statement__ = 98;
        current_statement__ = 98;
        check_less_or_equal(function__, "test_treatment[sym1__]",
                            test_treatment[(sym1__ - 1)], 1);}
      current_statement__ = 99;
      validate_non_negative_index("y", "N", N);
      current_statement__ = 100;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(N));
      y = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> y_flat__;
        current_statement__ = 100;
        assign(y_flat__, nil_index_list(), context__.vals_r("y"),
          "assigning variable y_flat__");
        current_statement__ = 100;
        pos__ = 1;
        current_statement__ = 100;
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          current_statement__ = 100;
          assign(y, cons_list(index_uni(sym1__), nil_index_list()),
            y_flat__[(pos__ - 1)], "assigning variable y");
          current_statement__ = 100;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 101;
      validate_non_negative_index("test_y", "N_test", N_test);
      current_statement__ = 102;
      context__.validate_dims("data initialization","test_y","double",
          context__.to_vec(N_test));
      test_y = Eigen::Matrix<double, -1, 1>(N_test);
      stan::math::fill(test_y, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> test_y_flat__;
        current_statement__ = 102;
        assign(test_y_flat__, nil_index_list(), context__.vals_r("test_y"),
          "assigning variable test_y_flat__");
        current_statement__ = 102;
        pos__ = 1;
        current_statement__ = 102;
        for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
          current_statement__ = 102;
          assign(test_y, cons_list(index_uni(sym1__), nil_index_list()),
            test_y_flat__[(pos__ - 1)], "assigning variable test_y");
          current_statement__ = 102;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 103;
      validate_non_negative_index("test_sigma_y_k", "K_test", K_test);
      current_statement__ = 104;
      context__.validate_dims("data initialization","test_sigma_y_k",
          "double",context__.to_vec(K_test));
      test_sigma_y_k = Eigen::Matrix<double, -1, 1>(K_test);
      stan::math::fill(test_sigma_y_k, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> test_sigma_y_k_flat__;
        current_statement__ = 104;
        assign(test_sigma_y_k_flat__, nil_index_list(),
          context__.vals_r("test_sigma_y_k"),
          "assigning variable test_sigma_y_k_flat__");
        current_statement__ = 104;
        pos__ = 1;
        current_statement__ = 104;
        for (int sym1__ = 1; sym1__ <= K_test; ++sym1__) {
          current_statement__ = 104;
          assign(test_sigma_y_k,
            cons_list(index_uni(sym1__), nil_index_list()),
            test_sigma_y_k_flat__[(pos__ - 1)],
            "assigning variable test_sigma_y_k");
          current_statement__ = 104;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 105;
      K_pooled = std::numeric_limits<int>::min();
      
      current_statement__ = 105;
      K_pooled = (logical_eq(pooling_type, 2) ? 0 : K);
      current_statement__ = 106;
      L_Omega_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 106;
      L_Omega_1dim__ = (primitive_value(logical_eq(joint_prior_variance, 1))
          && primitive_value(logical_eq(pooling_type, 1)));
      current_statement__ = 106;
      validate_non_negative_index("L_Omega",
                                  "joint_prior_variance == 1 && pooling_type == 1",
                                  L_Omega_1dim__);
      current_statement__ = 107;
      validate_non_negative_index("L_Omega", "P", P);
      current_statement__ = 107;
      validate_non_negative_index("L_Omega", "P", P);
      current_statement__ = 108;
      hypersd_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 108;
      hypersd_1dim__ = logical_eq(pooling_type, 1);
      current_statement__ = 108;
      validate_non_negative_index("hypersd", "pooling_type == 1",
                                  hypersd_1dim__);
      current_statement__ = 109;
      validate_non_negative_index("hypersd", "P", P);
      current_statement__ = 110;
      mu_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 110;
      mu_1dim__ = logical_neq(pooling_type, 0);
      current_statement__ = 110;
      validate_non_negative_index("mu", "pooling_type != 0", mu_1dim__);
      current_statement__ = 111;
      validate_non_negative_index("mu", "P", P);
      current_statement__ = 112;
      eta_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 112;
      eta_1dim__ = logical_neq(pooling_type, 2);
      current_statement__ = 112;
      validate_non_negative_index("eta", "pooling_type != 2", eta_1dim__);
      current_statement__ = 113;
      validate_non_negative_index("eta", "P", P);
      current_statement__ = 114;
      validate_non_negative_index("eta", "K", K);
      current_statement__ = 115;
      validate_non_negative_index("beta", "Nc", Nc);
      current_statement__ = 116;
      validate_non_negative_index("sigma_y_k", "K", K);
      current_statement__ = 117;
      theta_k_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 117;
      theta_k_1dim__ = logical_neq(pooling_type, 2);
      current_statement__ = 117;
      validate_non_negative_index("theta_k", "pooling_type != 2",
                                  theta_k_1dim__);
      current_statement__ = 118;
      validate_non_negative_index("theta_k", "P", P);
      current_statement__ = 119;
      validate_non_negative_index("theta_k", "K", K);
      current_statement__ = 120;
      tau_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 120;
      tau_1dim__ = logical_eq(pooling_type, 1);
      current_statement__ = 120;
      validate_non_negative_index("tau", "pooling_type == 1", tau_1dim__);
      current_statement__ = 121;
      validate_non_negative_index("tau", "P", P);
      current_statement__ = 122;
      validate_non_negative_index("tau", "P", P);
      current_statement__ = 123;
      logpd_1dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 123;
      logpd_1dim__ = logical_gt(K_test, 0);
      current_statement__ = 123;
      validate_non_negative_index("logpd", "K_test > 0", logpd_1dim__);
      current_statement__ = 124;
      validate_non_negative_index("fe_test", "N_test", N_test);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += L_Omega_1dim__ * ((P * (P - 1)) / 2);
      num_params_r__ += hypersd_1dim__ * P;
      num_params_r__ += mu_1dim__ * P;
      num_params_r__ += eta_1dim__ * P * K;
      num_params_r__ += Nc;
      num_params_r__ += K;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_mutau_full_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> L_Omega;
      L_Omega = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(L_Omega_1dim__, Eigen::Matrix<local_scalar_t__, -1, -1>(P, P));
      stan::math::fill(L_Omega, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> L_Omega_in__;
      L_Omega_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(L_Omega_1dim__, Eigen::Matrix<local_scalar_t__, -1, 1>(
        ((P * (P - 1)) / 2)));
      stan::math::fill(L_Omega_in__, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= L_Omega_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(L_Omega_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(((P * (P - 1)) / 2)), "assigning variable L_Omega_in__");
      }
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= L_Omega_1dim__; ++sym1__) {
        current_statement__ = 1;
        if (jacobian__) {
          current_statement__ = 1;
          assign(L_Omega, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::cholesky_corr_constrain(L_Omega_in__[(sym1__ - 1)],
              P, lp__), "assigning variable L_Omega");
        } else {
          current_statement__ = 1;
          assign(L_Omega, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::cholesky_corr_constrain(L_Omega_in__[(sym1__ - 1)], P),
            "assigning variable L_Omega");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> hypersd;
      hypersd = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(hypersd_1dim__, Eigen::Matrix<local_scalar_t__, -1, 1>(P));
      stan::math::fill(hypersd, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= hypersd_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(hypersd, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(P), "assigning variable hypersd");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= hypersd_1dim__; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          current_statement__ = 2;
          if (jacobian__) {
            current_statement__ = 2;
            assign(hypersd,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lb_constrain(hypersd[(sym1__ - 1)][(sym2__ - 1)],
                0, lp__), "assigning variable hypersd");
          } else {
            current_statement__ = 2;
            assign(hypersd,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__), nil_index_list())),
              stan::math::lb_constrain(hypersd[(sym1__ - 1)][(sym2__ - 1)], 0),
              "assigning variable hypersd");
          }}}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(mu_1dim__, Eigen::Matrix<local_scalar_t__, -1, 1>(P));
      stan::math::fill(mu, DUMMY_VAR__);
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(P), "assigning variable mu");}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> eta;
      eta = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(eta_1dim__, Eigen::Matrix<local_scalar_t__, -1, -1>(P, K));
      stan::math::fill(eta, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= eta_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(eta, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(P, K), "assigning variable eta");}
      Eigen::Matrix<local_scalar_t__, -1, 1> beta;
      beta = Eigen::Matrix<local_scalar_t__, -1, 1>(Nc);
      stan::math::fill(beta, DUMMY_VAR__);
      
      current_statement__ = 5;
      beta = in__.vector(Nc);
      Eigen::Matrix<local_scalar_t__, -1, 1> sigma_y_k;
      sigma_y_k = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(sigma_y_k, DUMMY_VAR__);
      
      current_statement__ = 6;
      sigma_y_k = in__.vector(K);
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 6;
        if (jacobian__) {
          current_statement__ = 6;
          assign(sigma_y_k, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_y_k[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma_y_k");
        } else {
          current_statement__ = 6;
          assign(sigma_y_k, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_y_k[(sym1__ - 1)], 0),
            "assigning variable sigma_y_k");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> theta_k;
      theta_k = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(theta_k_1dim__, Eigen::Matrix<local_scalar_t__, -1, -1>(P, K));
      stan::math::fill(theta_k, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>> tau;
      tau = std::vector<Eigen::Matrix<local_scalar_t__, -1, -1>>(tau_1dim__, Eigen::Matrix<local_scalar_t__, -1, -1>(P, P));
      stan::math::fill(tau, DUMMY_VAR__);
      
      current_statement__ = 10;
      if (logical_eq(pooling_type, 0)) {
        current_statement__ = 9;
        assign(theta_k, cons_list(index_uni(1), nil_index_list()),
          eta[(1 - 1)], "assigning variable theta_k");
      } 
      current_statement__ = 16;
      if (logical_eq(pooling_type, 1)) {
        current_statement__ = 13;
        if (joint_prior_variance) {
          current_statement__ = 12;
          assign(tau, cons_list(index_uni(1), nil_index_list()),
            diag_pre_multiply(hypersd[(1 - 1)], L_Omega[(1 - 1)]),
            "assigning variable tau");
        } else {
          current_statement__ = 11;
          assign(tau, cons_list(index_uni(1), nil_index_list()),
            diag_matrix(hypersd[(1 - 1)]), "assigning variable tau");
        }
        current_statement__ = 14;
        assign(theta_k, cons_list(index_uni(1), nil_index_list()),
          add(rep_matrix(mu[(1 - 1)], K),
            multiply(tau[(1 - 1)], eta[(1 - 1)])),
          "assigning variable theta_k");
      } 
      {
        current_statement__ = 31;
        validate_non_negative_index("y_mean", "N", N);
        Eigen::Matrix<local_scalar_t__, -1, 1> y_mean;
        y_mean = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
        stan::math::fill(y_mean, DUMMY_VAR__);
        
        current_statement__ = 45;
        if (logical_gt(N, 0)) {
          current_statement__ = 37;
          if (logical_eq(Nc, 0)) {
            current_statement__ = 36;
            assign(y_mean, nil_index_list(), rep_vector(0.0, N),
              "assigning variable y_mean");
          } else {
            current_statement__ = 33;
            assign(y_mean, nil_index_list(), multiply(X, beta),
              "assigning variable y_mean");
            current_statement__ = 34;
            lp_accum__.add(
              vecprior_lpdf<propto__>(beta, prior_beta_fam,
                prior_beta_val, pstream__));
          }
          current_statement__ = 40;
          if (logical_neq(pooling_baseline, 2)) {
            current_statement__ = 39;
            assign(y_mean, nil_index_list(),
              add(stan::model::deep_copy(y_mean),
                to_vector(
                  rvalue(theta_k[(1 - 1)],
                    cons_list(index_uni(1),
                      cons_list(index_multi(site), nil_index_list())),
                    "theta_k[1]"))), "assigning variable y_mean");
          } else {
            current_statement__ = 38;
            assign(y_mean, nil_index_list(),
              add(stan::model::deep_copy(y_mean), mu[(1 - 1)][(1 - 1)]),
              "assigning variable y_mean");
          }
          current_statement__ = 43;
          if (logical_neq(pooling_type, 2)) {
            current_statement__ = 42;
            assign(y_mean, nil_index_list(),
              add(stan::model::deep_copy(y_mean),
                elt_multiply(treatment,
                  to_vector(
                    rvalue(theta_k[(1 - 1)],
                      cons_list(index_uni(2),
                        cons_list(index_multi(site), nil_index_list())),
                      "theta_k[1]")))), "assigning variable y_mean");
          } else {
            current_statement__ = 41;
            assign(y_mean, nil_index_list(),
              add(stan::model::deep_copy(y_mean),
                multiply(treatment, mu[(1 - 1)][(2 - 1)])),
              "assigning variable y_mean");
          }
        } 
        current_statement__ = 52;
        if (logical_gt(pooling_type, 0)) {
          current_statement__ = 50;
          if (joint_prior_mean) {
            current_statement__ = 49;
            lp_accum__.add(
              multi_normal_lpdf<propto__>(mu[(1 - 1)], prior_hypermean_mean,
                prior_hypermean_scale));
          } 
        } else {
          current_statement__ = 47;
          for (int k = 1; k <= K; ++k) {
            current_statement__ = 46;
            lp_accum__.add(
              multi_normal_lpdf<propto__>(
                rvalue(eta[(1 - 1)],
                  cons_list(index_omni(),
                    cons_list(index_uni(k), nil_index_list())), "eta[1]"),
                prior_hypermean_mean, prior_hypermean_scale));}
        }
        current_statement__ = 59;
        if (logical_eq(pooling_type, 1)) {
          current_statement__ = 53;
          lp_accum__.add(std_normal_lpdf<propto__>(to_vector(eta[(1 - 1)])));
          current_statement__ = 54;
          lp_accum__.add(
            realprior_lpdf<propto__>(hypersd[(1 - 1)][(1 - 1)],
              prior_hypersd_fam, prior_hypersd_val, pstream__));
          current_statement__ = 55;
          lp_accum__.add(
            realprior_lpdf<propto__>(hypersd[(1 - 1)][(2 - 1)],
              prior_control_sd_fam, prior_control_sd_val, pstream__));
          current_statement__ = 57;
          if (joint_prior_variance) {
            current_statement__ = 56;
            lp_accum__.add(
              lkj_corr_cholesky_lpdf<propto__>(L_Omega[(1 - 1)],
                prior_hypercor_val));
          } 
        } 
        current_statement__ = 60;
        lp_accum__.add(
          normal_lpdf<propto__>(y, y_mean,
            rvalue(sigma_y_k, cons_list(index_multi(site), nil_index_list()),
              "sigma_y_k")));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_mutau_full_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<Eigen::Matrix<double, -1, -1>> L_Omega;
      L_Omega = std::vector<Eigen::Matrix<double, -1, -1>>(L_Omega_1dim__, Eigen::Matrix<double, -1, -1>(P, P));
      stan::math::fill(L_Omega, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> L_Omega_in__;
      L_Omega_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(L_Omega_1dim__, Eigen::Matrix<local_scalar_t__, -1, 1>(
        ((P * (P - 1)) / 2)));
      stan::math::fill(L_Omega_in__, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= L_Omega_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(L_Omega_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(((P * (P - 1)) / 2)), "assigning variable L_Omega_in__");
      }
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= L_Omega_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(L_Omega, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::cholesky_corr_constrain(L_Omega_in__[(sym1__ - 1)], P),
          "assigning variable L_Omega");}
      std::vector<Eigen::Matrix<double, -1, 1>> hypersd;
      hypersd = std::vector<Eigen::Matrix<double, -1, 1>>(hypersd_1dim__, Eigen::Matrix<double, -1, 1>(P));
      stan::math::fill(hypersd, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= hypersd_1dim__; ++sym1__) {
        current_statement__ = 2;
        assign(hypersd, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(P), "assigning variable hypersd");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= hypersd_1dim__; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          current_statement__ = 2;
          assign(hypersd,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lb_constrain(hypersd[(sym1__ - 1)][(sym2__ - 1)], 0),
            "assigning variable hypersd");}}
      std::vector<Eigen::Matrix<double, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<double, -1, 1>>(mu_1dim__, Eigen::Matrix<double, -1, 1>(P));
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        current_statement__ = 3;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(P), "assigning variable mu");}
      std::vector<Eigen::Matrix<double, -1, -1>> eta;
      eta = std::vector<Eigen::Matrix<double, -1, -1>>(eta_1dim__, Eigen::Matrix<double, -1, -1>(P, K));
      stan::math::fill(eta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= eta_1dim__; ++sym1__) {
        current_statement__ = 4;
        assign(eta, cons_list(index_uni(sym1__), nil_index_list()),
          in__.matrix(P, K), "assigning variable eta");}
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(Nc);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      beta = in__.vector(Nc);
      Eigen::Matrix<double, -1, 1> sigma_y_k;
      sigma_y_k = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(sigma_y_k, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      sigma_y_k = in__.vector(K);
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 6;
        assign(sigma_y_k, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma_y_k[(sym1__ - 1)], 0),
          "assigning variable sigma_y_k");}
      std::vector<Eigen::Matrix<double, -1, -1>> theta_k;
      theta_k = std::vector<Eigen::Matrix<double, -1, -1>>(theta_k_1dim__, Eigen::Matrix<double, -1, -1>(P, K));
      stan::math::fill(theta_k, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, -1>> tau;
      tau = std::vector<Eigen::Matrix<double, -1, -1>>(tau_1dim__, Eigen::Matrix<double, -1, -1>(P, P));
      stan::math::fill(tau, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= L_Omega_1dim__; ++sym3__) {
            vars__.emplace_back(
              rvalue(L_Omega,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                "L_Omega"));}}}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= hypersd_1dim__; ++sym2__) {
          vars__.emplace_back(hypersd[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
          vars__.emplace_back(mu[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= eta_1dim__; ++sym3__) {
            vars__.emplace_back(
              rvalue(eta,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))), "eta"));
          }}}
      for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(sigma_y_k[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 10;
      if (logical_eq(pooling_type, 0)) {
        current_statement__ = 9;
        assign(theta_k, cons_list(index_uni(1), nil_index_list()),
          eta[(1 - 1)], "assigning variable theta_k");
      } 
      current_statement__ = 16;
      if (logical_eq(pooling_type, 1)) {
        current_statement__ = 13;
        if (joint_prior_variance) {
          current_statement__ = 12;
          assign(tau, cons_list(index_uni(1), nil_index_list()),
            diag_pre_multiply(hypersd[(1 - 1)], L_Omega[(1 - 1)]),
            "assigning variable tau");
        } else {
          current_statement__ = 11;
          assign(tau, cons_list(index_uni(1), nil_index_list()),
            diag_matrix(hypersd[(1 - 1)]), "assigning variable tau");
        }
        current_statement__ = 14;
        assign(theta_k, cons_list(index_uni(1), nil_index_list()),
          add(rep_matrix(mu[(1 - 1)], K),
            multiply(tau[(1 - 1)], eta[(1 - 1)])),
          "assigning variable theta_k");
      } 
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            for (int sym3__ = 1; sym3__ <= theta_k_1dim__; ++sym3__) {
              vars__.emplace_back(
                rvalue(theta_k,
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__),
                      cons_list(index_uni(sym1__), nil_index_list()))),
                  "theta_k"));}}}
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            for (int sym3__ = 1; sym3__ <= tau_1dim__; ++sym3__) {
              vars__.emplace_back(
                rvalue(tau,
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__),
                      cons_list(index_uni(sym1__), nil_index_list()))),
                  "tau"));}}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<double> logpd;
      logpd = std::vector<double>(logpd_1dim__, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> fe_test;
      fe_test = Eigen::Matrix<double, -1, 1>(N_test);
      stan::math::fill(fe_test, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 30;
      if (logical_gt(K_test, 0)) {
        current_statement__ = 21;
        if (logical_eq(Nc, 0)) {
          current_statement__ = 20;
          assign(fe_test, nil_index_list(), rep_vector(0.0, N_test),
            "assigning variable fe_test");
        } else {
          current_statement__ = 19;
          assign(fe_test, nil_index_list(), multiply(X_test, beta),
            "assigning variable fe_test");
        }
        current_statement__ = 22;
        assign(logpd, cons_list(index_uni(1), nil_index_list()), 0,
          "assigning variable logpd");
        current_statement__ = 28;
        for (int i = 1; i <= N_test; ++i) {
          current_statement__ = 24;
          if (logical_eq(pooling_type, 1)) {
            current_statement__ = 23;
            assign(logpd, cons_list(index_uni(1), nil_index_list()),
              (logpd[(1 - 1)] +
                normal_lpdf<false>(test_y[(i - 1)],
                  ((mu[(1 - 1)][(1 - 1)] +
                     (mu[(1 - 1)][(2 - 1)] * test_treatment[(i - 1)])) +
                    fe_test[(i - 1)]),
                  stan::math::sqrt(
                    ((pow(hypersd[(1 - 1)][(1 - 1)], 2) +
                       pow(hypersd[(1 - 1)][(2 - 1)], 2)) +
                      pow(test_sigma_y_k[(test_site[(i - 1)] - 1)], 2))))),
              "assigning variable logpd");
          } 
          current_statement__ = 26;
          if (logical_eq(pooling_type, 2)) {
            current_statement__ = 25;
            assign(logpd, cons_list(index_uni(1), nil_index_list()),
              (logpd[(1 - 1)] +
                normal_lpdf<false>(test_y[(i - 1)],
                  ((mu[(1 - 1)][(1 - 1)] +
                     (mu[(1 - 1)][(2 - 1)] * test_treatment[(i - 1)])) +
                    fe_test[(i - 1)]),
                  stan::math::sqrt(
                    pow(test_sigma_y_k[(test_site[(i - 1)] - 1)], 2)))),
              "assigning variable logpd");
          } }
      } 
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        vars__.emplace_back(logpd[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
        vars__.emplace_back(fe_test[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<Eigen::Matrix<double, -1, -1>> L_Omega;
      L_Omega = std::vector<Eigen::Matrix<double, -1, -1>>(L_Omega_1dim__, Eigen::Matrix<double, -1, -1>(P, P));
      stan::math::fill(L_Omega, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> L_Omega_flat__;
        current_statement__ = 1;
        assign(L_Omega_flat__, nil_index_list(), context__.vals_r("L_Omega"),
          "assigning variable L_Omega_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 1;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 1;
            for (int sym3__ = 1; sym3__ <= L_Omega_1dim__; ++sym3__) {
              current_statement__ = 1;
              assign(L_Omega,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                L_Omega_flat__[(pos__ - 1)], "assigning variable L_Omega");
              current_statement__ = 1;
              pos__ = (pos__ + 1);}}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> L_Omega_free__;
      L_Omega_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(L_Omega_1dim__, Eigen::Matrix<double, -1, 1>(
        ((P * (P - 1)) / 2)));
      stan::math::fill(L_Omega_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= L_Omega_1dim__; ++sym1__) {
        current_statement__ = 1;
        assign(L_Omega_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::cholesky_corr_free(L_Omega[(sym1__ - 1)]),
          "assigning variable L_Omega_free__");}
      std::vector<Eigen::Matrix<double, -1, 1>> hypersd;
      hypersd = std::vector<Eigen::Matrix<double, -1, 1>>(hypersd_1dim__, Eigen::Matrix<double, -1, 1>(P));
      stan::math::fill(hypersd, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> hypersd_flat__;
        current_statement__ = 2;
        assign(hypersd_flat__, nil_index_list(), context__.vals_r("hypersd"),
          "assigning variable hypersd_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= hypersd_1dim__; ++sym2__) {
            current_statement__ = 2;
            assign(hypersd,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              hypersd_flat__[(pos__ - 1)], "assigning variable hypersd");
            current_statement__ = 2;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> hypersd_free__;
      hypersd_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(hypersd_1dim__, Eigen::Matrix<double, -1, 1>(P));
      stan::math::fill(hypersd_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= hypersd_1dim__; ++sym1__) {
        current_statement__ = 2;
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          current_statement__ = 2;
          assign(hypersd_free__,
            cons_list(index_uni(sym1__),
              cons_list(index_uni(sym2__), nil_index_list())),
            stan::math::lb_free(hypersd[(sym1__ - 1)][(sym2__ - 1)], 0),
            "assigning variable hypersd_free__");}}
      std::vector<Eigen::Matrix<double, -1, 1>> mu;
      mu = std::vector<Eigen::Matrix<double, -1, 1>>(mu_1dim__, Eigen::Matrix<double, -1, 1>(P));
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mu_flat__;
        current_statement__ = 3;
        assign(mu_flat__, nil_index_list(), context__.vals_r("mu"),
          "assigning variable mu_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
          current_statement__ = 3;
          for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
            current_statement__ = 3;
            assign(mu,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              mu_flat__[(pos__ - 1)], "assigning variable mu");
            current_statement__ = 3;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, -1>> eta;
      eta = std::vector<Eigen::Matrix<double, -1, -1>>(eta_1dim__, Eigen::Matrix<double, -1, -1>(P, K));
      stan::math::fill(eta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> eta_flat__;
        current_statement__ = 4;
        assign(eta_flat__, nil_index_list(), context__.vals_r("eta"),
          "assigning variable eta_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 4;
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            current_statement__ = 4;
            for (int sym3__ = 1; sym3__ <= eta_1dim__; ++sym3__) {
              current_statement__ = 4;
              assign(eta,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                eta_flat__[(pos__ - 1)], "assigning variable eta");
              current_statement__ = 4;
              pos__ = (pos__ + 1);}}}
      }
      Eigen::Matrix<double, -1, 1> beta;
      beta = Eigen::Matrix<double, -1, 1>(Nc);
      stan::math::fill(beta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> beta_flat__;
        current_statement__ = 5;
        assign(beta_flat__, nil_index_list(), context__.vals_r("beta"),
          "assigning variable beta_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
          current_statement__ = 5;
          assign(beta, cons_list(index_uni(sym1__), nil_index_list()),
            beta_flat__[(pos__ - 1)], "assigning variable beta");
          current_statement__ = 5;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> sigma_y_k;
      sigma_y_k = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(sigma_y_k, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sigma_y_k_flat__;
        current_statement__ = 6;
        assign(sigma_y_k_flat__, nil_index_list(),
          context__.vals_r("sigma_y_k"),
          "assigning variable sigma_y_k_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 6;
          assign(sigma_y_k, cons_list(index_uni(sym1__), nil_index_list()),
            sigma_y_k_flat__[(pos__ - 1)], "assigning variable sigma_y_k");
          current_statement__ = 6;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> sigma_y_k_free__;
      sigma_y_k_free__ = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(sigma_y_k_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 6;
        assign(sigma_y_k_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma_y_k[(sym1__ - 1)], 0),
          "assigning variable sigma_y_k_free__");}
      for (int sym1__ = 1; sym1__ <= L_Omega_1dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= ((P * (P - 1)) / 2); ++sym2__) {
          vars__.emplace_back(L_Omega_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= hypersd_1dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          vars__.emplace_back(hypersd_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= mu_1dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          vars__.emplace_back(mu[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= eta_1dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= P; ++sym3__) {
            vars__.emplace_back(
              rvalue(eta,
                cons_list(index_uni(sym1__),
                  cons_list(index_uni(sym3__),
                    cons_list(index_uni(sym2__), nil_index_list()))), "eta"));
          }}}
      for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
        vars__.emplace_back(beta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(sigma_y_k_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("L_Omega");
    names__.emplace_back("hypersd");
    names__.emplace_back("mu");
    names__.emplace_back("eta");
    names__.emplace_back("beta");
    names__.emplace_back("sigma_y_k");
    names__.emplace_back("theta_k");
    names__.emplace_back("tau");
    names__.emplace_back("logpd");
    names__.emplace_back("fe_test");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(L_Omega_1dim__)
                                             , static_cast<size_t>(P),
                                             static_cast<size_t>(P)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(hypersd_1dim__)
                                             , static_cast<size_t>(P)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(mu_1dim__),
                                             static_cast<size_t>(P)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(eta_1dim__),
                                             static_cast<size_t>(P),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(Nc)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(theta_k_1dim__)
                                             , static_cast<size_t>(P),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(tau_1dim__),
                                             static_cast<size_t>(P),
                                             static_cast<size_t>(P)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(logpd_1dim__)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N_test)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= L_Omega_1dim__; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "L_Omega" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= hypersd_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "hypersd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= eta_1dim__; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "eta" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_y_k" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= theta_k_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "theta_k" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= tau_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "tau" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "logpd" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "fe_test" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= ((P * (P - 1)) / 2); ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= L_Omega_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "L_Omega" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= hypersd_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "hypersd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= eta_1dim__; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "eta" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= Nc; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "beta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_y_k" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= theta_k_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "theta_k" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= P; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= P; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= tau_1dim__; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "tau" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= logpd_1dim__; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "logpd" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= N_test; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "fe_test" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"L_Omega\",\"type\":{\"name\":\"array\",\"length\":" << L_Omega_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << P << ",\"cols\":" << P << "}},\"block\":\"parameters\"},{\"name\":\"hypersd\",\"type\":{\"name\":\"array\",\"length\":" << hypersd_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << P << "}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << mu_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << P << "}},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"array\",\"length\":" << eta_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << P << ",\"cols\":" << K << "}},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << Nc << "},\"block\":\"parameters\"},{\"name\":\"sigma_y_k\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"theta_k\",\"type\":{\"name\":\"array\",\"length\":" << theta_k_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << P << ",\"cols\":" << K << "}},\"block\":\"transformed_parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"array\",\"length\":" << tau_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << P << ",\"cols\":" << P << "}},\"block\":\"transformed_parameters\"},{\"name\":\"logpd\",\"type\":{\"name\":\"array\",\"length\":" << logpd_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"fe_test\",\"type\":{\"name\":\"vector\",\"length\":" << N_test << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"L_Omega\",\"type\":{\"name\":\"array\",\"length\":" << L_Omega_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << ((P * (P - 1)) / 2) << "}},\"block\":\"parameters\"},{\"name\":\"hypersd\",\"type\":{\"name\":\"array\",\"length\":" << hypersd_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << P << "}},\"block\":\"parameters\"},{\"name\":\"mu\",\"type\":{\"name\":\"array\",\"length\":" << mu_1dim__ << ",\"element_type\":{\"name\":\"vector\",\"length\":" << P << "}},\"block\":\"parameters\"},{\"name\":\"eta\",\"type\":{\"name\":\"array\",\"length\":" << eta_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << P << ",\"cols\":" << K << "}},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"vector\",\"length\":" << Nc << "},\"block\":\"parameters\"},{\"name\":\"sigma_y_k\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"theta_k\",\"type\":{\"name\":\"array\",\"length\":" << theta_k_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << P << ",\"cols\":" << K << "}},\"block\":\"transformed_parameters\"},{\"name\":\"tau\",\"type\":{\"name\":\"array\",\"length\":" << tau_1dim__ << ",\"element_type\":{\"name\":\"matrix\",\"rows\":" << P << ",\"cols\":" << P << "}},\"block\":\"transformed_parameters\"},{\"name\":\"logpd\",\"type\":{\"name\":\"array\",\"length\":" << logpd_1dim__ << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"},{\"name\":\"fe_test\",\"type\":{\"name\":\"vector\",\"length\":" << N_test << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_mutau_full_namespace::model_mutau_full;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_mutau_full_namespace::profiles__;
}
#endif
#endif
