% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise_quantiles_data.R
\name{summarise_quantiles_data}
\alias{summarise_quantiles_data}
\title{summarise_quantiles_data}
\usage{
summarise_quantiles_data(
  data,
  quantiles,
  outcome = "outcome",
  group = "group",
  treatment = "treatment",
  means_only = FALSE
)
}
\arguments{
\item{data}{a data.frame with grouping, outcome, treatment variables}

\item{quantiles}{a vector of quantiles (between 0 and 1)}

\item{outcome}{character: column name in \code{data} for outcome variable}

\item{group}{character: column name in \code{data} for grouping variable}

\item{treatment}{character: column name in \code{data} for treatment variable}

\item{means_only}{logical; if true, covariances and extra outputs are not
returned, but only means (\code{y_0} and \code{y_1})}
}
\value{
A list with mean estimates for control and treatment (\code{y_0} and \code{y_1}) and
variance-covariance matrices (\code{Sigma_y_k_0} and \code{Sigma_y_k_1}).
}
\description{
Given individual level data, return list of summary statistics
Of quantile means and Sigma's, as well as K, N.
This operation is done automatically inside \link{baggr} function
but it can be used for exploring input data.
}
\details{
This function is intended for data exploration outside of \link{baggr}
function. When calling \link{baggr}, individual-level data should be supplied --
they will be summarised automatically.
(See \link{baggr} for documentation of how columns should be formatted.)

Estimates are obtained externally via \code{quantreg::rq} function of the
\code{quantreg} package. This implementation is experimental and will change in the
future versions of the package.
}
\examples{
\donttest{
summarise_quantiles_data(microcredit_simplified, c(.2, .4, .6),
                         outcome = "consumption")
}
}
