% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_prior-constructors.R
\name{NFix}
\alias{NFix}
\title{Normal Prior with Fixed Variance}
\usage{
NFix(sd = 1)
}
\arguments{
\item{sd}{Standard deviation. Default is \code{1}.}
}
\value{
An object of class \code{"bage_prior_normfixed"}.
}
\description{
Normal prior where, in contrast to \code{\link[=N]{N()}}, the
variance is treated as fixed and known. Typically
used for main effects or interactions where there
are too few elements to reliably estimate variance
from the available data.
}
\details{
\code{NFix()} is the default prior for the intercept.
}
\section{Mathematical details}{


\deqn{\beta_j \sim \text{N}(0, \tau^2)}

where \eqn{\beta} is the main effect or interaction,
and a value for \code{sd} is supplied by the user.
}

\examples{
NFix()
NFix(sd = 10)
}
\seealso{
\itemize{
\item \code{\link[=N]{N()}} Similar to \code{NFix()}, but standard deviation
parameter is estimated from the data rather
than being fixed in advance
\item \link{priors} Overview of priors implemented in \pkg{bage}
\item \code{\link[=set_prior]{set_prior()}} Specify prior for intercept,
main effect, or interaction
\item \href{https://bayesiandemography.github.io/bage/articles/vig02_math.html}{Mathematical Details}
vignette
}
}
