% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.helpers.R
\name{class.convert}
\alias{class.convert}
\title{Convert graph object to adjacency matrix}
\usage{
class.convert(graph, convert = "matrix", extract = FALSE)
}
\arguments{
\item{graph}{matrix, sparse matrix, \link{igraph}, edgelist, or \link[network]{network} object}

\item{convert}{class to convert to, one of "matrix", "sparseMatrix", "igraph", "edgelist", or "network"}

\item{extract}{Boolean, TRUE if using function within backbone.extract, FALSE if not.}
}
\value{
list(class, adjacency), a list containing the class of parameter graph, and the adjacency matrix of the graph
}
\description{
Convert graph object to adjacency matrix
}
\details{
An object is considered an edgelist if it is (1) a matrix or sparse matrix, and (2) has only two columns.
    Each column is understood as a bipartite set, with edges only going between members of column 1 and members of column 2.
}
\examples{
\dontrun{davis.sp <- as(davis, "sparseMatrix")}
\dontrun{davis.graph <- igraph::graph.incidence(davis)}
\dontrun{davis.nw <- network::network(davis, ignore.eval = FALSE,
    names.eval = "weight", loops = TRUE)}
\dontrun{backbone:::class.convert(davis, "matrix")}
\dontrun{backbone:::class.convert(davis.sp, "matrix")}
\dontrun{backbone:::class.convert(davis.graph, "matrix")}
\dontrun{backbone:::class.convert(davis.nw, "matrix")}
\dontrun{bb.sdsm <- sdsm(davis)}
\dontrun{bb <- backbone.extract(bb.sdsm, signed = TRUE, alpha = .2)}
\dontrun{backbone:::class.convert(bb, "matrix")}
\dontrun{backbone:::class.convert(bb, "sparseMatrix")}
\dontrun{backbone:::class.convert(bb, "igraph")}
\dontrun{backbone:::class.convert(bb, "network")}
}
\keyword{internal}
