% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imphdaft.R
\name{imphdaft}
\alias{imphdaft}
\title{High dimensional missing data imputation and performing mediation analysis with univariate accelerated failure time
model using Weibull distribution.}
\usage{
imphdaft(m, n, survdur, event, time, sig, ths, b, d, data)
}
\arguments{
\item{m}{Starting column number from where high dimensional variates to be selected.}

\item{n}{Ending column number till where high dimensional variates to be selected.}

\item{survdur}{"Column/Variable name" consisting duration of survival.}

\item{event}{"Column/Variable name" consisting survival event.}

\item{time}{"Column/Variable name" consisting time of repeated observations.}

\item{sig}{Level of significance pre-determined by the user}

\item{ths}{A numeric between 0 to 100.}

\item{b}{Number of MCMC iterations to burn.}

\item{d}{Number of draws for the iterations.}

\item{data}{High dimensional data containing survival observations with multiple covariates.}
}
\value{
Data frame containing the beta and alpha values of active variables among the significant variables.
}
\description{
Given the dimension of variables and survival information the function performs
imputations using missForest function and filters significant variables,
allowing the user to fit AFT model. Further, it performs mediation analysis among the signifiant
variables and provides handful variables with their alpha.a values which are mediator model exposure coefficients
and beta.a coefficients.
}
\examples{
##
\dontrun{
imphdaft(m=6,n=25,survdur="OS",event="event",time="Visit",sig=0.5,ths=0.02,b=10,d=10,data=srdata)
}
##
}
