% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit2summary.R
\name{fit2stats}
\alias{fit2stats}
\title{Summarize statistics with a model}
\usage{
fit2stats(fit, method = "likelihood", digits = 2)
}
\arguments{
\item{fit}{An object of class lm or glm}

\item{method}{character choices are one of the c("likelihood","wald")}

\item{digits}{integer indicating the number of decimal places}
}
\value{
An object of class "data.frame"
}
\description{
Summarize statistics with a model
}
\examples{
library(survival)
data(cancer)
fit=glm(status~rx+sex+age+obstruct+nodes,data=colon,family="binomial")
fit2stats(fit)
fit=lm(mpg~wt*hp+am,data=mtcars)
fit2stats(fit)
}
