% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-state.r
\name{auk_state}
\alias{auk_state}
\title{Filter the eBird data by state}
\usage{
auk_state(x, state, replace = FALSE)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}

\item{state}{character; states to filter by. eBird uses 4 to 6 character
state codes consisting of two parts, the 2-letter ISO country code and a
1-3 character state code, separated by a dash. For example, \code{"US-NY"}
corresponds to New York State in the United States. Refer to the data frame
\link{ebird_states} for look up state codes.}

\item{replace}{logical; multiple calls to \code{auk_state()} are additive,
unless \code{replace = FALSE}, in which case the previous list of states to
filter by will be removed and replaced by that in the current call.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) based on a set of
states. This function only defines the filter and, once all filters have
been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and perform the
filtering.
}
\details{
It is not possible to filter by both country and state, so calling
\code{auk_state()} will reset the country filter to all countries, and vice versa.

This function can also work with on an \code{auk_sampling} object if the user only
wishes to filter the sampling event data.
}
\examples{
# state codes for a given country can be looked up in ebird_states
dplyr::filter(ebird_states, country == "Costa Rica")
# choose texas, united states and puntarenas, cost rica
states <- c("US-TX", "CR-P")
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_state(states)
  
# alternatively, without pipes
ebd <- auk_ebd(system.file("extdata/ebd-sample.txt", package = "auk"))
auk_state(ebd, states)
}
\seealso{
Other filter: \code{\link{auk_bbox}},
  \code{\link{auk_bcr}}, \code{\link{auk_breeding}},
  \code{\link{auk_complete}}, \code{\link{auk_country}},
  \code{\link{auk_date}}, \code{\link{auk_distance}},
  \code{\link{auk_duration}}, \code{\link{auk_extent}},
  \code{\link{auk_filter}}, \code{\link{auk_last_edited}},
  \code{\link{auk_project}}, \code{\link{auk_protocol}},
  \code{\link{auk_species}}, \code{\link{auk_time}}
}
\concept{filter}
