% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-zerofill.r
\name{auk_zerofill}
\alias{auk_zerofill}
\alias{auk_zerofill.data.frame}
\alias{auk_zerofill.character}
\alias{auk_zerofill.auk_ebd}
\alias{collapse_zerofill}
\title{Read and zero-fill an eBird data file}
\usage{
auk_zerofill(x, ...)

\method{auk_zerofill}{data.frame}(x, sampling_events, species,
  unique = TRUE, collapse = FALSE, ...)

\method{auk_zerofill}{character}(x, sampling_events, species,
  sep = "\\t", unique = TRUE, collapse = FALSE, ...)

\method{auk_zerofill}{auk_ebd}(x, species, sep = "\\t", unique = TRUE,
  collapse = FALSE, ...)

collapse_zerofill(x)
}
\arguments{
\item{x}{filename, \code{data.frame} of eBird observations, or \code{auk_ebd} object
with associated output files as created by \code{\link[=auk_filter]{auk_filter()}}. If a filename is
provided, it must point to the EBD and the \code{sampling_events} argument must
point to the sampling event data file. If a \code{data.frame} is provided it
should have been imported with \code{\link[=read_ebd]{read_ebd()}}, to ensure the variables names
have been set correctly, and it must have been passed through
\code{\link[=auk_unique]{auk_unique()}} to ensure duplicate group checklists have been removed.}

\item{...}{additional arguments passed to methods.}

\item{sampling_events}{character or \code{data.frame}; filename for the sampling
event data or a \code{data.frame} of the same data. If a \code{data.frame} is
provided it should have been imported with \code{\link[=read_sampling]{read_sampling()}}, to ensure the
variables names have been set correctly, and it must have been passed
through \code{\link[=auk_unique]{auk_unique()}} to ensure duplicate group checklists have been
removed.}

\item{species}{character; species to include in zero-filled dataset, provided
as scientific or English common names, or a mixture of both. These names
must match the official eBird Taxomony (\link{ebird_taxonomy}). To include all
species, leave this argument blank.}

\item{unique}{logical; should \code{\link[=auk_unique]{auk_unique()}} be run on the input data if it
hasn't already.}

\item{collapse}{logical; whether to call \code{collapse_zerofill()} to return a
data frame rather than an \code{auk_zerofill} object.}

\item{sep}{character; single character used to separate fields within a row.}
}
\value{
By default, an \code{auk_zerofill} object, or a data frame if \code{collapse = TRUE}.
}
\description{
Read an eBird Basic Dataset (EBD) file, and associated sampling event data file, to
produce a zero-filled, presence-absence dataset. The EBD contains bird
sightings and the sampling event data is a set of all checklists, they can be
combined to infer absence data by assuming any species not reported on a
checklist was had a count of zero.
}
\details{
\code{auk_zerofill()} generates an \code{auk_zerofill} object consisting of a list with
elements \code{observations} and \code{sampling_events}. \code{observations} is a data frame
giving counts and binary presence/absence data for each species.
\code{sampling_events} is a data frame with checklist level information. The two
data frames can be connected via the \code{checklist_id} field. This format is
efficient for storage since the checklist columns are not duplicated for each
species, however, working with the data often requires joining the two data
frames together.

To return a data frame, set \code{collapse = TRUE}. Alternatively,
\code{zerofill_collapse()} generates a data frame from an \code{auk_zerofill} object,
by joining the two data frames together to produce a single data frame in
which each row provides both checklist and species information for a
sighting.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: EBD data frame.

\item \code{character}: Filename of EBD.

\item \code{auk_ebd}: \code{auk_ebd} object output from \code{\link[=auk_filter]{auk_filter()}}. Must
have had a sampling event data file set in the original call to
\code{\link[=auk_ebd]{auk_ebd()}}.
}}

\examples{
# read and zero-fill the sampling data
f_ebd <- system.file("extdata/zerofill-ex_ebd.txt", package = "auk")
f_smpl <- system.file("extdata/zerofill-ex_sampling.txt", package = "auk")
auk_zerofill(x = f_ebd, sampling_events = f_smpl)

# use the species argument to only include a subset of species
auk_zerofill(x = f_ebd, sampling_events = f_smpl,
             species = "Collared Kingfisher")

# to return a data frame use collapse = TRUE
ebd_df <- auk_zerofill(x = f_ebd, sampling_events = f_smpl, collapse = TRUE)
}
\seealso{
Other import: \code{\link{read_ebd}}
}
\concept{import}
