% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotD3_roc.R
\name{plotD3_roc}
\alias{plotD3_roc}
\title{Receiver Operating Characteristic (ROC) in D3 with r2d3 package.}
\usage{
plotD3_roc(object, ..., nlabel = NULL, scale_plot = FALSE)
}
\arguments{
\item{object}{An object of class \code{auditor_model_evaluation} created with \code{\link{model_evaluation}} function.}

\item{...}{Other \code{auditor_model_evaluation} objects to be plotted together.}

\item{nlabel}{Number of cutoff points to show on the plot. Default is \code{NULL}.}

\item{scale_plot}{Logical, indicates whenever the plot should scale with height. By default it's \code{FALSE}.}
}
\value{
a \code{r2d3} object
}
\description{
Receiver Operating Characteristic Curve is a plot of the true positive rate (TPR)
 against the false positive rate (FPR) for the different thresholds.
It is useful for measuring and comparing the accuracy of the classificators.
}
\examples{
data(titanic_imputed, package = "DALEX")

# fit a model
model_glm <- glm(survived ~ ., family = binomial, data = titanic_imputed)

# use DALEX package to wrap up a model into explainer
glm_audit <- audit(model_glm,
                   data = titanic_imputed,
                   y = titanic_imputed$survived)

# validate a model with auditor
eva_glm <- model_evaluation(glm_audit)

# plot results
plot_roc(eva_glm)
plot(eva_glm)

#add second model
model_glm_2 <- glm(survived ~ .-age, family = binomial, data = titanic_imputed)
glm_audit_2 <- audit(model_glm_2,
                     data = titanic_imputed,
                     y = titanic_imputed$survived,
                     label = "glm2")
eva_glm_2 <- model_evaluation(glm_audit_2)

plotD3_roc(eva_glm, eva_glm_2)

}
\seealso{
\code{\link{plot_roc}}
}
