% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_rroc.R
\name{plot_rroc}
\alias{plot_rroc}
\alias{plotRROC}
\title{Regression Receiver Operating Characteristic (RROC)}
\usage{
plot_rroc(object, ...)

plotRROC(object, ...)
}
\arguments{
\item{object}{An object of class 'auditor_model_residual' created with \code{\link{model_residual}} function.}

\item{...}{Other 'auditor_model_residual' objects to be plotted together.}
}
\value{
A ggplot object.
}
\description{
The basic idea of the ROC curves for regression is to show model asymmetry.
The RROC is a plot where on the x-axis we depict total over-estimation and on the y-axis total
under-estimation.
}
\details{
For RROC curves we use a shift, which is an equivalent to the threshold for ROC curves.
For each observation we calculate new prediction: \eqn{\hat{y}'=\hat{y}+s} where s is the shift.
Therefore, there are different error values for each shift: \eqn{e_i = \hat{y_i}' - y_i}

Over-estimation is calculated as: \eqn{OVER= \sum(e_i|e_i>0)}.

Under-estimation is calculated as: \eqn{UNDER = \sum(e_i|e_i<0)}.

 The shift equals 0 is represented by a dot.

 The Area Over the RROC Curve (AOC) equals to the variance of the errors multiplied by \eqn{frac{n^2}{2}}.
}
\examples{
dragons <- DALEX::dragons[1:100, ]

# fit a model
model_lm <- lm(life_length ~ ., data = dragons)

# use DALEX package to wrap up a model into explainer
exp_lm <- DALEX::explain(model_lm, data = dragons, y = dragons$life_length)

# validate a model with auditor
library(auditor)
mr_lm <- model_residual(exp_lm)

# plot results
plot_rroc(mr_lm)
plot(mr_lm, type = "rroc")

library(randomForest)
model_rf <- randomForest(life_length~., data = dragons)
exp_rf <- DALEX::explain(model_rf, data = dragons, y = dragons$life_length)
mr_rf <- model_residual(exp_rf)
plot_rroc(mr_lm, mr_rf)
plot(mr_lm, mr_rf, type="rroc")

}
\references{
Hernández-Orallo, José. 2013. ‘ROC Curves for Regression’. Pattern Recognition 46 (12): 3395–3411.
}
\seealso{
\code{ \link{plot_roc}, \link{plot_rec}}
}
