% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCooksDistance.R
\name{plotCooksDistance}
\alias{plotCooksDistance}
\title{Influence of observations plot}
\usage{
plotCooksDistance(object, nlabel = 3, ...)
}
\arguments{
\item{object}{An object of class ModelAudit.}

\item{nlabel}{Number of observations with the biggest Cook's distances to be labeled.}

\item{...}{Other arguments passed to \code{\link{scoreCooksDistance}}.}
}
\description{
Cook’s distances are used for estimate the influence of an single observation.
}
\details{
Cook’s distance is a tool for identifying observations that may negatively affect the model.
They may be also used for indicating regions of the design space where it would be good to obtain more observations.
Data points indicated by Cook’s distances are worth checking for validity.

Cook’s Distances are calculated by removing the i-th observation from the data and recalculating the model.
It shows how much all the values in the model change when the i-th observation is removed.

For model classes other than lm and glm the distances are computed directly from the definition.
}
\examples{
library(car)
lm_model <- lm(prestige~education + women + income, data = Prestige)
lm_au <- audit(lm_model, data = Prestige, y = Prestige$prestige)
plotCooksDistance(lm_au)

}
