% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-bps.R
\name{load_bps}
\alias{load_bps}
\title{Extracts the names of the epibenthic biomasspools from the initial conditions file.}
\usage{
load_bps(fgs, init)
}
\arguments{
\item{fgs}{Character string giving the connection to the functional groups file.
The filename usually contains \code{Groups} and does end in \code{.csv}.}

\item{init}{Character string giving the connection of the initial conditions netcdf file.
The filename usually contains \code{init} and ends in \code{.nc}.}
}
\value{
Character \code{vector} of epibenthic biomass pools.
}
\description{
Use \code{fgs} \code{data.frame} as read in by \code{\link{load_fgs}}
to get the biomass pool information.
}
\examples{
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")

fgs <- file.path(d, "SETasGroupsDem_NoCep.csv")
init <- file.path(d, "INIT_VMPA_Jan2015.nc")

load_bps(fgs, init)
}
\seealso{
\code{\link{load_fgs}}

Other load functions: \code{\link{load_box}},
  \code{\link{load_dietcheck}}, \code{\link{load_fgs}},
  \code{\link{load_init_age}}, \code{\link{load_init}},
  \code{\link{load_nc_physics}}, \code{\link{load_nc}},
  \code{\link{load_rec}}, \code{\link{load_spec_mort}},
  \code{\link{load_txt}}
}
