% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change-prm.R
\name{change_prm}
\alias{change_prm}
\title{Change biological parameterfile to simplify automated ATLANTIS calibrations.}
\usage{
change_prm(prm_biol, select_acronyms, roc, parameter, relative = TRUE,
  save_to_disc = TRUE, version_flag = 2)
}
\arguments{
\item{prm_biol}{Character string giving the connection to the biological parameterfile.
The filename usually contains \code{biol_fishing} and does end in \code{.prm}.}

\item{select_acronyms}{Character vector of functional groups which shall be read in.
Names have to match the ones used in the *.prm file. Check column "Code" in
"functionalGroups.csv" for clarification.}

\item{roc}{Vector of multiplication factors which shall be applied to the old set of parameters.
Please supply one value per selected group. In case relative is FALSE the new absolute values
can be passed as roc.}

\item{parameter}{Character value of the model parameter which shall be changed.
Only one parameter can be selected per function call.}

\item{relative}{Logical if TRUE values are changed relative to base values. If FALSE new values can
be passed directly. Default is \code{TRUE}.}

\item{save_to_disc}{Logical indicating if the resulting prm file should be overwritten
(\code{TRUE}) or not (\code{FALSE}). Defaults to \code{TRUE}.}

\item{version_flag}{The version of ATLANTIS model. 1 for bec_dev, 2 for trunk. \code{default is 2.}.}
}
\value{
parameterfile *.prm file with the new parameter values.
}
\description{
This function is used to help automate the calibration routine for ATLANTIS models.
}
\examples{
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
prm_biol <- file.path(d, "VMPA_setas_biol_fishing_Trunk.prm")

new_prm <- change_prm(prm_biol,
                      select_acronyms = c("FPS", "FVS"),
                      roc = c(2,3),
                      parameter = "KWRR",
                      save_to_disc = FALSE)
}
