% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{chaining_functions}
\alias{chaining_functions}
\alias{chain_start}
\alias{chain_end}
\title{Chaining functions}
\usage{
chain_start(data)

chain_end(data, success_fun = success_continue,
  error_fun = error_report)
}
\arguments{
\item{data}{A data frame}

\item{success_fun}{Function to call if assertion passes. Defaults to
returning \code{data}.}

\item{error_fun}{Function to call if assertion fails. Defaults to printing
a summary of all errors.}
}
\description{
These functions are for starting and ending a sequence of assertr
assertions and overriding the default behavior of assertr halting
execution on the first error.
}
\details{
For more information, read the relevant section in this package's
vignette using, \code{vignette("assertr")}

For examples of possible choices for the \code{success_fun} and
\code{error_fun} parameters, run \code{help("success_and_error_functions")}
}
\examples{
library(magrittr)

mtcars \%>\%
  chain_start() \%>\%
  verify(nrow(mtcars) > 10) \%>\%
  verify(mpg > 0) \%>\%
  insist(within_n_sds(4), mpg) \%>\%
  assert(in_set(0,1), am, vs) \%>\%
  chain_end()
}
