\name{rankindex.new}
\alias{rankindex.new}
\title{Compares the efficacy of resemblance measures for a particular data 
scenario.}  
\description{
This function is a wrapper for \code{\link[vegan]{rankindex}} from \code{vegan}.
}
\usage{

rankindex.new(grad, veg, indices = c("matching", "rogers", "jaccard.pa", 
"sorenson", "kulkczynski.pa", "ochiai", "gower", "steinhaus", "kulkczynski.q", 
"jaccard.q", "euclidean", "rel.euclidean", "manhattan", "czekanowski", 
"whittaker", "canberra", "chi.metric", "chi.dist", "morisita", "morisita.horn", 
"minkowski", "mountford", "raup.crick", "binomial", "chao"), stepacross = FALSE,
 method = "pearson", ...)
}

\arguments{

  \item{grad}{An \emph{s} x \emph{e} matrix of environmental variables, where \emph{s} = the number 
  of sites and \emph{e} = the number of environmental variables.}
  \item{veg}{An \emph{s} x \emph{p} community matrix, where \emph{s} = the number 
  of sites and \emph{p} = the number of species.}
  \item{indices}{Some subset from the character string: \code{c("matching", "rogers", 
  "jaccard.pa", "sorenson", "kulkczynski.pa", "ochiai", "gower", "steinhaus", 
  "kulkczynski.q", "jaccard.q", "euclidean", "rel.euclidean", "manhattan", 
  "czekanowski", "whittaker", "canberra", "chi.metric", "chi.dist", "morisita", 
  "morisita.horn", "minkowski", "mountford", "raup.crick", "binomial", "chao")}.}
  \item{stepacross}{Logical, specifies whether a step across transformation 
  should be applied to the resemblance matrix.}
  \item{method}{What method is used to calculate correlations between 
  environmental and communtiy matrices.  Must be one of \code{"pearson", "kendall"}, or \code{"spearman"}. }
  \item{\dots}{Other parameters to \code{\link[vegan]{stepacross}} from \code{vegan}.}
}

\details{A number of ecologists have evaluated the performance of distance measures by 
comparing environmental distance (i.e. differences along gradients) to distance 
in ordination space (Beals, 1984; Faith et al., 1987; De'ath, 1999).  If species 
distributions are well described by environmental variables, then a strong 
association should exist between distances in species space and differences in 
environmental space.  Thus, poor correlations represent poor performance by the 
distance measure.  Obviously this analysis becomes more meaningful as the number 
of important environmental variables increases in ones measure of environmental distance.
The library \code{vegan} has a function called rankindex which ranks dissimilarity or 
distances used for finding community distances or dissimilarities by how well 
these indices agree with gradient differences.  The gradient separation between 
each point is expressed as Euclidean distance for continuous variables  and as 
Gower's metric for mixed data (i.e. when at least some environmental variables 
are categorical or ordinal).  In the later case the library \pkg{cluster} is required.  
The association of community and environmental distance matrices is simply the 
correlation of the community and environmental distance ranks and can be 
measured with any of the conventional measures described in Ch. 11.  The 
function \code{rankindex.new} is a wrapper for \code{\link[vegan]{rankindex}} and uses Oksanen's 
method to compare the efficacy of 25 of the 26 indices generated by \code{get.dist}.  
Mahalanobis distance is left out, since it does not create a distance matrix 
\emph{per se}, but a simultaneous comparison of each site to all other sites.}
\value{
The function returns  a table of ranked Pearson's correlations (default) and a barplot.}
\references{Oksanen, J., Kindt, R., Legendre, P., O'Hara, B., Simpson, G. L., and Stevens, M. H. H.  
(2008) \emph{vegan: community ecology package. R package version 1.13-0}.  \url{http://vegan.r-forge.r-project.org/}
}
\author{Ken Aho}
\seealso{\code{\link{get.dist}}}
\examples{
\dontrun{
library(vegan)
data(varechem)
data(varespec)
r<-rankindex.new(scale(varechem),varespec)}
}
\keyword{multivariate}
