% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidLists.R
\name{tidLists-class}
\alias{tidLists-class}
\alias{tidLists}
\alias{initialize,tidLists-method}
\alias{show,tidLists-method}
\alias{summary,tidLists-method}
\alias{summary.tidLists-class}
\alias{show,summary.tidLists-method}
\alias{dim,tidLists-method}
\alias{dimnames,tidLists-method}
\alias{dimnames<-,tidLists,list-method}
\alias{length,tidLists-method}
\alias{t,tidLists-method}
\alias{transactionInfo,tidLists-method}
\alias{transactionInfo<-,tidLists-method}
\alias{itemInfo,tidLists-method}
\alias{itemInfo<-,tidLists-method}
\alias{itemLabels,tidLists-method}
\alias{labels,tidLists-method}
\alias{coercion-tidLists}
\alias{coerce,tidLists,matrix-method}
\alias{coerce,tidLists,list-method}
\alias{coerce,list,tidLists-method}
\alias{coerce,tidLists,ngCMatrix-method}
\alias{coerce,tidLists,transactions-method}
\alias{coerce,transactions,tidLists-method}
\alias{coerce,tidLists,itemMatrix-method}
\alias{coerce,itemMatrix,tidLists-method}
\title{Class tidLists --- Transaction ID Lists for Items/Itemsets}
\usage{
tidLists(x)

\S4method{summary}{tidLists}(object, maxsum = 6, ...)

\S4method{dim}{tidLists}(x)

\S4method{dimnames}{tidLists}(x)

\S4method{dimnames}{tidLists,list}(x) <- value

\S4method{length}{tidLists}(x)

\S4method{t}{tidLists}(x)

\S4method{transactionInfo}{tidLists}(x)

\S4method{transactionInfo}{tidLists}(x) <- value

\S4method{itemInfo}{tidLists}(object)

\S4method{itemInfo}{tidLists}(object) <- value

\S4method{itemLabels}{tidLists}(object)

\S4method{labels}{tidLists}(object)
}
\arguments{
\item{x, object}{the object}

\item{maxsum}{maximum numbers of itemsets shown in the summary}

\item{...}{further arguments}

\item{value}{replacement value}
}
\description{
Class to represent transaction ID lists and associated methods.
}
\details{
Transaction ID lists contains a set of lists.  Each list is associated with
an item/itemset and stores the IDs of the transactions which support the
item/itemset.

\code{tidLists} uses the class
\link[Matrix:nsparseMatrix-classes]{Matrix::ngCMatrix} to efficiently store the
transaction ID lists as a sparse matrix.  Each column in the matrix
represents one transaction ID list.

\code{tidLists} can be used for different purposes.  For some operations
(e.g., support counting) it is efficient to coerce a
\link{transactions} database into \code{tidLists} where each
list contains the transaction IDs for an item (and the support is given by
the length of the list).

The implementation of the Eclat mining algorithm (which uses transaction ID
list intersection) can also produce transaction ID lists for the found
itemsets as part of the returned \link{itemsets} object.
These lists can then be used for further computation.
}
\section{Functions}{
\itemize{
\item \code{summary(tidLists)}: create a summary

\item \code{dim(tidLists)}: get dimensions. The rows represent the itemsets and the
columns are the transactions.

\item \code{dimnames(tidLists)}: get dimnames

\item \code{dimnames(x = tidLists) <- value}: replace dimnames

\item \code{length(tidLists)}: get the number of itemsets.

\item \code{t(tidLists)}: this object is not transposable.
\code{t()} results in an error.

\item \code{transactionInfo(tidLists)}: get the transaction info data.frame

\item \code{transactionInfo(tidLists) <- value}: replace the the transaction info data.frame

\item \code{itemInfo(tidLists)}: get the item info data.frame

\item \code{itemInfo(tidLists) <- value}: replace the item info data.frame

\item \code{itemLabels(tidLists)}: get the item labels

\item \code{labels(tidLists)}: convert the tid lists into a text representation.

}}
\section{Slots}{

\describe{
\item{\code{data}}{an object of class \link[Matrix:nsparseMatrix-classes]{Matrix::ngCMatrix}.}

\item{\code{itemInfo}}{a data.frame}

\item{\code{transactionInfo}}{a data.frame}
}}

\section{Objects from the Class}{

Objects are created
\itemize{
\item as part of the
\link{itemsets} mined by \code{\link[=eclat]{eclat()}} with \code{tidLists = TRUE} in the
\link{ECparameter} object.
\item by \code{\link[=supportingTransactions]{supportingTransactions()}}.
\item by coercion from
an object of class \link{transactions}.
\item by calls of the form  \code{new("tidLists", ...)}.
}
}

\section{Coercions}{

\itemize{
\item \code{as("tidLists", "list")}
\item \code{as("list", "tidLists")}
\item \code{as("tidLists", "ngCMatrix")}
\item \code{as("tidLists", "transactions")}
\item \code{as("transactions", "tidLists")}
\item \code{as("tidLists", "itemMatrix")}
\item \code{as("itemMatrix", "tidLists")}
}
}

\examples{
## Create transaction data set.
data <- list(
  c("a","b","c"),
  c("a","b"),
  c("a","b","d"),
  c("b","e"),
  c("b","c","e"),
  c("a","d","e"),
  c("a","c"),
  c("a","b","d"),
  c("c","e"),
  c("a","b","d","e")
  )
data <- as(data, "transactions")
data

## convert transactions to transaction ID lists
tl <- as(data, "tidLists")
tl

inspect(tl)
dim(tl)
dimnames(tl)

## inspect visually
image(tl)

## mine itemsets with transaction ID lists
f <- eclat(data, parameter = list(support = 0, tidLists = TRUE))
tl2 <- tidLists(f)
inspect(tl2)
}
\seealso{
Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{c}()},
\code{\link{crossTable}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequency}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{supportingTransactions}()},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{itemMatrix and transactions functions}
\keyword{classes}
