% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage.R
\name{coverage}
\alias{coverage}
\alias{coverage,rules-method}
\title{Calculate coverage for rules}
\usage{
coverage(x, transactions = NULL, reuse = TRUE)

\S4method{coverage}{rules}(x, transactions = NULL, reuse = TRUE)
}
\arguments{
\item{x}{the set of \link{rules}.}

\item{transactions}{the data set used to generate \code{x}. Only needed if the
quality slot of \code{x} does not contain support and confidence.}

\item{reuse}{reuse support and confidence stored in \code{x} or recompute from
transactions?}
}
\value{
A numeric vector of the same length as \code{x} containing the
coverage values for the sets in \code{x}.
}
\description{
Provides the generic function and a method to calculate the
coverage (support of the left-hand-side) of \link{rules}.
}
\details{
Coverage (also called cover or LHS-support) is the support of the
left-hand-side of the rule \eqn{X => Y}, i.e., \eqn{supp(X)}. It represents a measure of
to how often the rule can be applied.

Coverage can be quickly calculated from the rule's quality measures (support and
confidence) stored in the quality slot. If these values are not present,
then the support of the LHS is counted using the data supplied in
\link{transactions}.

Coverage is also one of the measures available via the function
\code{\link[=interestMeasure]{interestMeasure()}}.
}
\examples{
data("Income")

## find and some rules (we only use 5 rules here) and calculate coverage
rules <- apriori(Income)[1:5]
quality(rules) <- cbind(quality(rules), coverage = coverage(rules))

inspect(rules)
}
\seealso{
Other interest measures: 
\code{\link{confint}()},
\code{\link{interestMeasure}()},
\code{\link{is.redundant}()},
\code{\link{is.significant}()},
\code{\link{support}()}
}
\author{
Michael Hahsler
}
\concept{interest measures}
\keyword{models}
