% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supportingTransactions.R
\name{supportingTransactions}
\alias{supportingTransactions}
\alias{supportingTransactions,associations-method}
\title{Supporting Transactions}
\usage{
supportingTransactions(x, transactions, ...)

\S4method{supportingTransactions}{associations}(x, transactions)
}
\arguments{
\item{x}{a set of \link{associations} (\link{itemsets}, \link{rules}, etc.)}

\item{transactions}{an object of class \link{transactions} used to mine the
associations in \code{x}.}

\item{...}{currently unused.}
}
\value{
An object of class \link{tidLists} containing one transaction ID
list per association in \code{x}.
}
\description{
Find for each itemset in an \link{associations} object which transactions support
(i.e., contains all items in the itemset) it. The information is returned
as a \link{tidLists} object.
}
\examples{
data <- list(
	c("a","b","c"),
	c("a","b"),
	c("a","b","d"),
	c("b","e"),
	c("b","c","e"),
	c("a","d","e"),
	c("a","c"),
	c("a","b","d"),
	c("c","e"),
	c("a","b","d","e")
	)
data <- as(data, "transactions")

## mine itemsets
f <- eclat(data, parameter = list(support = .2, minlen = 3))
inspect(f)

## find supporting Transactions
st <- supportingTransactions(f, data)
st

as(st, "list")
}
\seealso{
Other itemMatrix and transactions functions: 
\code{\link{abbreviate}()},
\code{\link{crossTable}()},
\code{\link{c}()},
\code{\link{duplicated}()},
\code{\link{extract}},
\code{\link{hierarchy}},
\code{\link{image}()},
\code{\link{inspect}()},
\code{\link{is.superset}()},
\code{\link{itemFrequencyPlot}()},
\code{\link{itemFrequency}()},
\code{\link{itemMatrix-class}},
\code{\link{match}()},
\code{\link{merge}()},
\code{\link{random.transactions}()},
\code{\link{sample}()},
\code{\link{sets}},
\code{\link{size}()},
\code{\link{tidLists-class}},
\code{\link{transactions-class}},
\code{\link{unique}()}
}
\author{
Michael Hahsler
}
\concept{itemMatrix and transactions functions}
\keyword{models}
