\name{is.maximal}
\alias{is.maximal}
\alias{is.maximal,itemMatrix-method}
\alias{is.maximal,itemsets-method}
\alias{is.maximal,rules-method}
%
%
\title{Find Maximal Itemsets}
\description{
Provides the generic function and the S4 method \code{is.maximal} for finding
maximal itemsets. Maximal frequent itemsets are used as a concise representation of frequent itemsets.
An itemset is maximal in a set if no proper superset of the
itemset is contained in the set (Zaki et al., 1997).

Maximally frequent itemsets can also be mined directly using \code{link{apriori}} or \code{link{eclat}} with target "maximally frequent itemsets".

We define here maximal rules, as the rules generated by maximal itemsets.
}
\usage{
is.maximal(x,\ldots)

\S4method{is.maximal}{itemMatrix}(x)
}
\arguments{
  \item{x}{ the set of itemsets, rules or an itemMatrix object. }
  \item{\ldots}{ further arguments.}
%  \item{blocksize}{a numeric value indicating how much memory can is.maximal
%    use for large \code{x} (approx. in MB). This is only a
%    crude approximation for 32-bit machines (64-bit architectures need
%    double the blocksize in memory).}
}
\value{a logical vector with the same length as \code{x} indicating
for each element in \code{x} if it is a maximal itemset.
}
\seealso{
\code{\link{itemMatrix-class}},
\code{\link{itemsets-class}},
\code{\link{is.generator}},
\code{\link{is.closed}}
}
\references{
Mohammed J. Zaki, Srinivasan Parthasarathy, Mitsunori Ogihara, and Wei Li
(1997). \emph{New algorithms for fast discovery of association rules}.
Technical Report 651, Computer Science Department, University of Rochester,
Rochester, NY 14627.
}
\author{Michael Hahsler}
\keyword{models}
