\name{ruleInduction}
\alias{ruleInduction}
\alias{ruleInduction,itemsets-method}
\title{Rule Induction for a Set of Itemsets}
\description{
   Provides the generic function and the needed S4 method to
   induce all rules which can be generated by the given itemsets
   from a transactions data set.
}
\usage{
ruleInduction(x, ...)
\S4method{ruleInduction}{itemsets}(x, transactions, confidence = 0.8, verbose = FALSE)
}
\arguments{
  \item{x}{ the set of itemsets from which rules will be induced. }
  \item{\dots}{ further arguments. }
  \item{transactions}{ the transaction data set used to mine 
  	the itemsets. }
  \item{confidence}{ \code{"numeric"}; minimum confidence for the rules. }  
  \item{verbose}{ \code{"logical"}; report progress. }  
}
\details{
  Currently, only a very simple rule induction method is implemented.
  All rules are mined from the transactions data set using the
  minimal support found in itemsets. And in a second step
  all rules which do not stem from one of the itemsets are removed.
  This procedure will be in many cases very slow (e.g., for itemsets 
  with many elements or very low support).
}
\value{
   An object of class \code{rules}.
}

\seealso{ \code{\link{itemsets-class}}, \code{\link{rules-class}}
\code{\link{transactions-class}}}
\examples{
data("Adult")

### find all closed frequent itemsets
closed <- apriori(Adult, 
	parameter = list(target = "closed", support = 0.4))

### rule induction
rules <- ruleInduction(closed, Adult, verbose = TRUE)

### inspect the resulting rules
inspect(SORT(rules, by = "lift")[1:5])
}
\keyword{models}
