% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array.R
\name{as_arrow_array}
\alias{as_arrow_array}
\alias{as_arrow_array.Array}
\alias{as_arrow_array.Scalar}
\alias{as_arrow_array.ChunkedArray}
\title{Convert an object to an Arrow Array}
\usage{
as_arrow_array(x, ..., type = NULL)

\method{as_arrow_array}{Array}(x, ..., type = NULL)

\method{as_arrow_array}{Scalar}(x, ..., type = NULL)

\method{as_arrow_array}{ChunkedArray}(x, ..., type = NULL)
}
\arguments{
\item{x}{An object to convert to an Arrow Array}

\item{...}{Passed to S3 methods}

\item{type}{A \link[=data-type]{type} for the final Array. A value of \code{NULL}
will default to the type guessed by \code{\link[=infer_type]{infer_type()}}.}
}
\value{
An \link{Array} with type \code{type}.
}
\description{
The \code{as_arrow_array()} function is identical to \code{Array$create()} except
that it is an S3 generic, which allows methods to be defined in other
packages to convert objects to \link{Array}. \code{Array$create()} is slightly faster
because it tries to convert in C++ before falling back on
\code{as_arrow_array()}.
}
\examples{
as_arrow_array(1:5)

}
