% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/2_SimpleModels.R
\name{M_M_S_K}
\alias{M_M_S_K}
\title{Obtains the main characteristics of a M/M/S/k queueing model}
\usage{
M_M_S_K(lambda = 3, mu = 6, s = 2, k = 3)
}
\arguments{
\item{lambda}{Mean arrival rate}

\item{mu}{Mean service rate}

\item{s}{Number of servers}

\item{k}{Maximun size of the queue}
}
\value{
Returns the next information of a M/M/S/K model:
\item{rho}{Constant coefficient: \eqn{\lambda/\rho}}
\item{barrho}{Traffic intensity: \ifelse{latex}{\eqn{\bar{\rho}}}{\out{<i>&#862;&rho;</i>}}}
\item{barlambda}{Effective arrival rate: \ifelse{latex}{\eqn{\bar{\lambda}}}{\out{<i>&#862;&lambda;</i>}}}
\item{cn}{Coefficients used in the computation of \ifelse{latex}{\eqn{P_n}: \eqn{C_n}}{\out{<i>P<sub>n</sub></i>: <i>C<sub>n</sub></i>}}}
\item{pks}{Probability of having \eqn{K+s} customers in the system: \ifelse{latex}{\eqn{P_{K+s}}}{\out{<i>P<sub>K+s</sub></i>}}}
\item{p0}{Probability of empty system: \ifelse{latex}{\eqn{P_{0}}}{\out{<i>P<sub>0</sub></i>}}}
\item{l}{Number of customers in the system: \eqn{L}}
\item{lq}{Number of customers in the queue: \ifelse{latex}{\eqn{L_{q}}}{\out{<i>L<sub>q</sub></i>}}}
\item{w}{Waiting time in the system: \eqn{W}}
\item{wq}{Waiting time in the queue: \ifelse{latex}{\eqn{W_{q}}}{\out{<i>W<sub>q</sub></i>}}}
\item{eff}{System efficiency: \ifelse{latex}{\eqn{Eff = W/(W-W_q)}}{\out{<i>Eff = W/(W-W<sub>q</sub></i>)}}}
}
\description{
Obtains the main characteristics of a M/M/S/k queueing model
}
\examples{
#A workstation with three processors
#runs programs with CPU time following
#an exponential distribution with mean 3 minutes.
#The programs arrive to the workstation following
#a Poisson process with an intensity of 15
#programs per hour.
#The workstation has a limited memory and only
#one program is allowed to wait if the processor
#is busy.

M_M_S_K(lambda=15, mu=60/3, s=3, k=1)
}
\seealso{
Other AnaliticalModels: \code{\link{ClosedJacksonNetwork}};
  \code{\link{M_M_1_INF_H}}; \code{\link{M_M_1_K}};
  \code{\link{M_M_1}}; \code{\link{M_M_INF}};
  \code{\link{M_M_S_INF_H_Y}}; \code{\link{M_M_S_INF_H}};
  \code{\link{M_M_S}}; \code{\link{OpenJacksonNetwork}}
}

