% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/2_SimpleModels.R
\name{M_M_1}
\alias{M_M_1}
\title{Obtains the main characteristics of a M/M/1 queueing model}
\usage{
M_M_1(lambda = 3, mu = 6)
}
\arguments{
\item{lambda}{Mean arrival rate}

\item{mu}{Mean service rate}
}
\value{
Returns the next information of a M/M/1 model:
\item{rho}{Traffic intensity: \eqn{\rho}}
\item{cn}{Coefficients used in the computation of \ifelse{latex}{\eqn{P_n}: \eqn{C_n}}{\out{<i>P<sub>n</sub>: C<sub>n</sub></i>}}}
\item{p0}{Probability of empty system: \ifelse{latex}{\eqn{P_{0}}}{\out{<i>P<sub>0</sub></i>}}}
\item{l}{Number of customers in the system: \eqn{L}}
\item{lq}{Number of customers in the queue: \ifelse{latex}{\eqn{L_q}}{\out{<i>L<sub>q</sub></i>}}}
\item{w}{Waiting time in the system: \eqn{W}}
\item{wq}{Waiting time in the queue: \ifelse{latex}{\eqn{W_q}}{\out{<i>W<sub>q</sub></i>}}}
\item{eff}{System efficiency: \ifelse{latex}{\eqn{Eff = W/(W-W_q)}}{\out{<i>Eff = W/(W-W<sub>q</sub>)</i>}}}
}
\description{
Obtains the main characteristics of a M/M/1 queueing model
}
\examples{
#A workstation with a single processor
#runs programs with CPU time following
#an exponential distribution with mean 3 minutes.
#The programs arrives to the workstation following
#a Poisson process with an intensity of 15
#programs per hour.

M_M_1(lambda=15, mu=60/3)
}
\seealso{
Other AnaliticalModels: \code{\link{ClosedJacksonNetwork}};
  \code{\link{M_M_1_INF_H}}; \code{\link{M_M_1_K}};
  \code{\link{M_M_INF}}; \code{\link{M_M_S_INF_H_Y}};
  \code{\link{M_M_S_INF_H}}; \code{\link{M_M_S_K}};
  \code{\link{M_M_S}}; \code{\link{OpenJacksonNetwork}}
}

