% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arakno.R
\name{records}
\alias{records}
\title{Get coordinate data from GBIF and WST.}
\usage{
records(tax, order = FALSE, verbose = TRUE)
}
\arguments{
\item{tax}{A taxon name or vector with taxa names.}

\item{order}{Order taxa names alphabetically or keep as in tax.}

\item{verbose}{Display information as data are retrieved.}
}
\value{
A data.frame with species name, longitude, latitude, source database and reference.
}
\description{
Downloads coordinate data from records in GBIF and the World Spider Trait database.
}
\details{
Outputs non-duplicate records with geographical (long, lat) coordinates.
As always when using data from multiple sources the user should be careful and check if records "make sense" before using them.
}
\examples{
\dontrun{
records("Pardosa hyperborea")
records(tax = c("Pardosa hyperborea", "Anapistula"), order = TRUE)
}
}
\references{
Pekar, S., Cernecka, L., Wolff, J., Mammola, S., Cardoso, P., Lowe, E., Fukushima, C.S., Birkhofer, K. & Herberstein, M.E. (2021). The world spider trait database. Masaryk University, Brno, URL: https://spidertraits.sci.muni.cz
}
