% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateAWC.R
\name{estimateAWC}
\alias{estimateAWC}
\title{Estimate available water capacity for fine-earth fraction}
\usage{
estimateAWC(texcl, omcl, precision = 2, FUN = mean, ...)
}
\arguments{
\item{texcl}{character, USDA textural class fine earth fraction}

\item{omcl}{integer, Organic matter class. 1: less than 1.5 percent, 2: less than 5, 3: greate than 5}

\item{precision}{integer, Number of decimal places in result default: 2}

\item{FUN}{Function for interpolating between table values default: \code{mean}}

\item{...}{Additional arguments to \code{FUN}}
}
\value{
A numeric vector double containing estimated available water capacities for fine-earth fraction.
}
\description{
Estimate available water capacity for fine-earth fraction
}
\examples{

# organic matter, loam texture, low medium and high OM
base.awc <- estimateAWC(c("l","l","l"), c(1, 2, 3), na.rm = TRUE)
base.awc

}
