\name{panel.depth_function}
\Rdversion{1.1}
\alias{panel.depth_function}

\title{Lattice Panel Function for Soil Profiles}

\description{Panel function for plotting grouped soil property data, along with upper and lower estimates of uncertainty.}

\usage{
panel.depth_function(x, y, id, upper = NA, lower = NA, 
subscripts = NULL, groups = NULL, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{x values (generated by calling lattice function)}
  \item{y}{y values (generated by calling lattice function)}
  \item{id}{vector of id labels, same length as x and y--only required when plotting segments (see Details section)}
  \item{upper}{vector of upper confidence envelope values}
  \item{lower}{vector of lower confidence envelope values}
  \item{subscripts}{paneling indices (generated by calling lattice function)}
  \item{groups}{grouping data (generated by calling lattice function)}
  \item{\dots}{further arguments to lower-level lattice plotting functions, see below}
}
\details{
This function can be used to replace \code{panel.superpose} when plotting depth function data.
}

\references{http://casoilresource.lawr.ucdavis.edu/}
\author{Dylan E. Beaudette}

\seealso{
\code{\link{sp1}}
}
\examples{
library(lattice)
data(sp1)

# 1. plotting mechanism for step-functions derived from soil profile data
xyplot(cbind(top,bottom) ~ prop, data=sp1,id=sp1$id,
panel=panel.depth_function, ylim=c(250,-10), 
scales=list(y=list(tick.number=10)), xlab='Property', 
ylab='Depth (cm)', main='panel.depth_function() demo'
)

# 1.1 include groups argument to leverage lattice styling framework
sp1$group <- factor(sp1$group, labels=c('Group 1', 'Group2'))

xyplot(cbind(top,bottom) ~ prop, groups=group, data=sp1, id=sp1$id,
panel=panel.depth_function, ylim=c(250,-10), 
scales=list(y=list(tick.number=10)), xlab='Property', 
ylab='Depth (cm)', main='panel.depth_function() demo',
auto.key=list(columns=2, points=FALSE, lines=TRUE),
par.settings=list(superpose.line=list(col=c('Orange','RoyalBlue')))
)


# 2. plotting upper/lower envelope around some value, by depth:
# profile data are aggregated ("slotted") by 1cm depth slices
a <- soil.slot(sp1)

# manually add mean +/- SD
a$upper <- with(a, p.mean+p.sd)
a$lower <- with(a, p.mean-p.sd)

# use custom plotting function for uncertainty viz.
xyplot(top ~ p.mean, data=a, 
lower=a$lower, upper=a$upper, ylim=c(250,-5), alpha=0.5, 
panel=panel.depth_function, 
prepanel=prepanel.depth_function
)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{hplot}
