% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randnor.R
\name{randnor}
\alias{randnor}
\title{Multivariable Random Normal data}
\usage{
randnor(n, mu, Cov)
}
\arguments{
\item{n}{the number of rows of observations in the dataset}

\item{mu}{a vector of length m containing the column means of the dataset}

\item{Cov}{an m x m covariance matrix}
}
\value{
A simulated matrix of values based on the input parameters is returned.
}
\description{
Generate a simulated multivariable random normally distributed dataset
using the method of Cholesky Decomposition.
}
\examples{
## Simulated data based on the iris dataset
mu <- c(rep(0, 4))
covmatr <- matrix(c(0.7, -0.04, 1.3, 0.5, -0.04, 0.2, -0.3, -0.1,
1.3, -0.3, 3.1, 1.3, 0.5, -0.1, 1.3, 0.6), ncol = 4)
sim.dat <- randnor(n = 100, mu = mu, Cov = covmatr)
head(sim.dat)

}
\references{
Rizzo M. L., \emph{"Statistical Computing with R", Chapman & Hall/CRC} (2007)
}

