% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pod_analysis.R
\name{bootstrap_metaregression}
\alias{bootstrap_metaregression}
\title{Perform Bootstrap Metaregression}
\usage{
bootstrap_metaregression(x, dataset_size, iterations = 1000)
}
\arguments{
\item{x}{an object of class \code{data.frame}.}

\item{dataset_size}{a numeric object with the size of an individual dataset
in \code{x}.}

\item{iterations}{the number of iterations to run; default is 1,000.}
}
\value{
bmr_obj a \code{bmr} object that holds all of the bootstrap
metaregression models produced.
}
\description{
Performs bootstrap metaregression on a concentration-response dataset.
}
\details{
This function performs bootstrap metaregression on a concentration-response
dataset. The dataset must be a data.frame with two columns:
1) Activity and 2) Concentration.
}
\examples{
bmr_obj <- bootstrap_metaregression(oxybenzone, 15, 100)
}

