% Generated by roxygen2 (4.0.2): do not edit by hand
\name{defineClass}
\alias{defineClass}
\alias{publicFunction}
\alias{publicValue}
\title{Define a new class}
\usage{
defineClass(name, expr, contains = NULL)

publicFunction(fun)

publicValue(x = NULL, validity = function(x) TRUE)
}
\arguments{
\item{name}{character name of the class}

\item{expr}{expression}

\item{contains}{character name of class from which to inherit}

\item{fun}{function definition}

\item{x}{a default value}

\item{validity}{an optional validity function for the set method. Returns TRUE or FALSE.}
}
\description{
\code{defineClass} has two side effects. First it creates an S4-Class and second it creates a constructor function named \code{name}. Use \code{publicFunction} and \code{publicValue} to make things public; everything else will be private.
}
\details{
All classes inherit from class "oom" which is a S4-class containing an environment. Inheritance is basically just setting the parent environment and at the same time making public functions available. The constructor function needs to be available and should not be changed.

Everything in \code{expr} will be part of the new class definition. If you want to make objects public use \code{publicFunction} and \code{publicValue}.

\code{publicValue} will create a function, if called without argument it will get the value, if called with argument it will set the value. You can set an optional validity function.
}
\examples{
test <- defineClass("test", {
  x <- publicValue(1)
  y <- NULL
  doSomething <- publicFunction(function() {
    y <<- y + 1
    invisible(self)
  })
})
instance <- test()
\dontrun{
instance$y # error
}
instance$doSomething()$doSomething()
instance$x()
instance$x(2)
instance$x()
}

