% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_exchanges.R
\name{exchangesStack}
\alias{exchangesStack}
\title{Plot the exchanges of an area}
\usage{
exchangesStack(x, area = NULL, mcYear = "average", dateRange = NULL,
  colors = NULL, main = NULL, ylab = NULL, unit = c("MWh", "GWh",
  "TWh"), compare = NULL, compareOpts = list(),
  interactive = getInteractivity(), legend = TRUE,
  legendId = sample(1e+09, 1), groupId = legendId, legendItemsPerRow = 5,
  width = NULL, height = NULL, xyCompare = c("union", "intersect"),
  h5requestFiltering = list(), stepPlot = FALSE, drawPoints = FALSE,
  timeSteph5 = "hourly", mcYearh5 = NULL, tablesh5 = c("areas", "links"),
  language = "en", hidden = NULL, ...)
}
\arguments{
\item{x}{Object of class \code{antaresData} created with function
\code{\link[antaresRead]{readAntares}}. It is required to contain link data.
If it also contains area data with column `ROW BAL.`, then exchanges with
the rest of the world are also displayed on the chart.}

\item{area}{Name of a single area. The flows from/to this area will be drawn by the
function.}

\item{mcYear}{If \code{x}, contains multiple Monte-Carlo scenarios, this parameter 
determine which scenario is displayed. Must be an integer representing the
index of the scenario or the word "average". In this case data are 
averaged.}

\item{dateRange}{A vector of two dates. Only data points between these two dates are 
displayed. If NULL, then all data is displayed.}

\item{colors}{Vector of colors with same length as parameter \code{variables}. If 
\code{variables} is an alias, then this argument should be \code{NULL} in 
order to use default colors.}

\item{main}{Title of the graph.}

\item{ylab}{Title of the Y-axis.}

\item{unit}{Unit used in the graph. Possible values are "MWh", "GWh" or "TWh".}

\item{compare}{An optional character vector containing names of parameters. When it is set,
two charts are outputed with their own input controls. Alternatively, it can
be a named list with names corresponding to parameter names and values being
list with the initial values of the given parameter for each chart. See details
 if you are drawing a map.}

\item{compareOpts}{List of options that indicates the number of charts to create and their 
position. Check out the documentation of 
\code{\link[manipulateWidget]{compareOptions}} to see available options.}

\item{interactive}{LogicalValue. If \code{TRUE}, then a shiny gadget is launched that lets
the user interactively choose the areas or districts to display.}

\item{legend}{Logical value indicating if a legend should be drawn. This argument is 
usefull when one wants to create a shared legend with
\code{\link{prodStackLegend}}}

\item{legendId}{Id of the legend linked to the graph. This argument is 
usefull when one wants to create a shared legend with 
\code{\link{prodStackLegend}}}

\item{groupId}{Parameter that can be used to synchronize the horizontal 
zoom of multiple charts. All charts that need to be synchronized must
have the same group.}

\item{legendItemsPerRow}{Number of elements to put in each row of the legend.}

\item{width}{Width of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{height}{Height of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{xyCompare}{Use when you compare studies, can be "union" or "intersect". If union, all
of mcYears in one of studies will be selectable. If intersect, only mcYears in all
studies will be selectable.}

\item{h5requestFiltering}{Contains arguments used by default for h5 request,
typically h5requestFiltering = list(select = "NUCLEAR")}

\item{stepPlot}{\code{boolean}, step style for curves.}

\item{drawPoints}{\code{boolean}, add points on graph}

\item{timeSteph5}{\code{character} timeStep to read in h5 file. Only for Non interactive mode.}

\item{mcYearh5}{\code{numeric} mcYear to read for h5. Only for Non interactive mode.}

\item{tablesh5}{\code{character} tables for h5 ("areas" "links", "clusters" or "disticts"). Only for Non interactive mode.}

\item{language}{\code{character} language use for label. Defaut to 'en'. Can be 'fr'.}

\item{hidden}{\code{logical} Names of input to hide. Defaut to NULL}

\item{...}{Other arguments for \code{\link{manipulateWidget}}}
}
\value{
A htmlwidget of class \code{dygraph}. It can be modified with functions from
package \code{dygraphs}.
}
\description{
This function draws a stack representing the evolution of the exchanges of
an area with its neighbours. Positive values denotes exports and negative 
values imports.
}
\details{
Compare argument can take following values :
\itemize{
   \item "mcYear"
   \item "main"
   \item "unit"
   \item "area"
   \item "legend"
   \item "stepPlot"
   \item "drawPoints"
   }
}
\examples{
\dontrun{
mydata <- readAntares(links = "all", timeStep = "daily")
exchangesStack(mydata)

# Also display exchanges with the rest of the world
mydata <- readAntares(areas = "all", links = "all", timeStep = "daily")
exchangesStack(mydata)

# Use compare :
exchangesStack(mydata, compare = "mcYear")
exchangesStack(mydata, compare = "area")
exchangesStack(mydata, compare = "unit")
exchangesStack(mydata, compare = "legend")

}

}
