% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surplusSectors.R
\name{surplusSectors}
\alias{surplusSectors}
\title{Compute the surplus of sectors}
\usage{
surplusSectors(x, sectors = c("thermal", "renewable"),
  timeStep = "annual", synthesis = FALSE, groupByDistrict = FALSE,
  clusterDesc = NULL, opts = NULL)
}
\arguments{
\item{x}{Object of class \code{antaresData} created with \code{readAntares}. It needs
to contain hourly detailed results of a simulation. Moreover, it must contain
area data and if thermal sectors are required, cluster data.}

\item{sectors}{vector containing the name of the sectors for which surplus needs to be
computed. Possible values are "thermal" for thermal sectors(nuclear, coal,..),
"ren" for renewable energie and any column name that can be considered as
a production (for instance production of virtual areas). It is assumed that
the cost of these productions is equal to 0 as for renewable energies.
If the parameter contains the value "thermal", then the parameter
\code{x} has to contain cluster data.}

\item{timeStep}{Desired time step for the result.}

\item{synthesis}{If TRUE, average surpluses are returned. Else the function returns surpluses
per Monte-Carlo scenario.}

\item{groupByDistrict}{If TRUE, results are grouped by district.}

\item{clusterDesc}{A table created with the function \code{\link[antaresRead]{readClusterDesc}}.
If is this parameter is set to \code{NULL} (the default), then the function
attemps to read the needed data in the same study as \code{x}.}

\item{opts}{opts}
}
\value{
A data.table of class "antaresData". It contains one column per sector
containing the surplus of that sector for a given area and timeId.
}
\description{
This function computes the surplus of sectors for each area and time step.
For sectors wind, solar, hydraulic storage and run of river, production costs
are assumed to be equal to 0.
}
\examples{
\dontrun{

# Data required by the function:
showAliases("surplusSectors")

mydata <- readAntares(select = "surplusSectors")
surplusSectors(mydata)

# Note that if the parameter "sectors" is modified, the function can require
# more or less data. For instance, if one only wants surplus for thermal
# sectors:
mydata <- readAntares(areas = "all", clusters = "all", synthesis = FALSE,
                      select = "MRG. PRICE")
surplusSectors(mydata, sectors = "thermal")

}

}
