% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadFactor.R
\name{loadFactor}
\alias{loadFactor}
\title{Load factors of clusters}
\usage{
loadFactor(x, timeStep = "annual", synthesis = FALSE, clusterDesc = NULL,
  loadFactorAvailable = FALSE)
}
\arguments{
\item{x}{Object of class \code{antaresData} created with function
\code{\link[antaresRead]{readAntares}}. It must contain hourly detailed
results for clusters and has to contain the columns
\code{minGenModulation}.}

\item{timeStep}{Desired time step for the result.}

\item{synthesis}{If TRUE, average surpluses are returned. Else the function returns surpluses
per Monte-Carlo scenario.}

\item{clusterDesc}{A table created with the function \code{\link[antaresRead]{readClusterDesc}}.
If is this parameter is set to \code{NULL} (the default), then the function
attemps to read the needed data in the same study as \code{x}.}

\item{loadFactorAvailable}{Should loadFactorAvailable be added to the result?}
}
\value{
a data.table of class \code{antaresDataTable}containing the following
columns:
\item{area}{Area name}
\item{cluster}{Cluster name}
\item{mcYear}{Only if \code{synthesis=FALSE}}. Id of the Monte-carlo scenario
\item{timeId}{Time id and other time variables}
\item{loadFactor}{
  Load factor of the cluster. It represent the proportion of
  the installed capacity of a cluster that is effectively generate

  Formula: production / (unitcount * nominalcapacity)
}
#' \item{loadFactorAvailable}{
  Load factor of the cluster. It represent the proportion of
  the capacity available of a cluster that is effectively generate

  Formula: production / thermalAvailability
}
\item{propHoursMinGen}{
  Proportion of hours when production is positive and
  all units of a cluster are either off, either producing at their minimum. This
  situation occurs when units are kept producing above the optimal level to avoid
  future startup costs or to satisfy the constraints generated by parameters
  "Min. up Time" or "Min gen. modulation".

  Formula: mean(1 if production > 0 and production = max(min.stable.power * unitcount,
  minGenModulation * nominalcapacity * unitcount) else 0)
}
\item{propHoursMaxGen}{
  Proportion of hours when all units started produce at
  their maximal capacity.

  Formula: mean(1 if production > 0 and production = NODU * nominalcapacity *
  (1 - spinning / 100))
}
}
\description{
This function computes the load factor and other related statistics
for cluster of a study.
}
\examples{
\dontrun{
# data required by the function
showAliases("loadfactor")

mydata <- readAntares(select = "loadfactor")
loadFactor(mydata, synthesis = TRUE)
}

}
