% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runTsGenerator.R
\name{runTsGenerator}
\alias{runTsGenerator}
\title{Run Time-Series Generator}
\usage{
runTsGenerator(path_solver = getOption("antares.solver"), wait = TRUE,
  show_output_on_console = FALSE, opts = antaresRead::simOptions())
}
\arguments{
\item{path_solver}{Character containing the Antares Solver path.}

\item{wait}{Logical, indicating whether the R interpreter should wait for the 
simulation to finish, or run it asynchronously.}

\item{show_output_on_console}{Logical, indicating whether to capture the ANTARES log and show 
it on the R console.}

\item{opts}{List of simulation parameters returned by the function
\code{antaresRead::setSimulationPath}.}
}
\description{
Run Time-Series Generator
}
\examples{
\dontrun{
library(antaresRead)
setSimulationPath(path = "path/to/study")
library(antaresEditObject)
runTsGenerator(
  path_solver = "path/to/antares-6.0-solver.exe", 
  show_output_on_console = TRUE
)
}
}
