% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{mysql.build}
\alias{mysql.build}
\title{Build annovarR database in mysql}
\usage{
mysql.build(filename = "", mysql.connect.params = list(host = "", dbname =
  "", table.name = "", user = "", password = ""), dat = data.table(),
  fread.params = list(), new.colnames = NULL, verbose = FALSE, ...)
}
\arguments{
\item{filename}{Path of raw data, will be read by fread}

\item{mysql.connect.params}{Mysql parameters, [host, dbname, table.name, user, password etc.]}

\item{dat}{Object of data.table, as the input data to build database}

\item{fread.params}{Other parameters be used in \code{\link[data.table]{fread}}}

\item{new.colnames}{New colnames of table, default is to retain the original}

\item{verbose}{Ligical indicating wheather show the log message}

\item{...}{Other parameters be used in dbWriteTable}
}
\description{
Build annovarR database in mysql
}
\examples{
test.dat <- system.file('extdata', 'demo/sqlite.dat.txt', package = 'annovarR')
\dontrun{
mysql.build(test.dat, list(host = 'host', dbname = 'db', 
table.name = 'table', user = 'user', password = 'password'))
}
}
