% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_raw.R
\name{Raw}
\alias{Raw}
\alias{RawR6}
\title{Create a Raw object}
\usage{
Raw(adata, X = NULL, var = NULL, varm = NULL)
}
\arguments{
\item{adata}{An AnnData object.}

\item{X}{A #observations × #variables data matrix.}

\item{var}{Key-indexed one-dimensional variables annotation of length #variables.}

\item{varm}{Key-indexed multi-dimensional variables annotation of length #variables.}
}
\description{
Create a Raw object
}
\examples{
\dontrun{
ad <- AnnData(
  X = matrix(c(0, 1, 2, 3), nrow = 2),
  obs = data.frame(group = c("a", "b"), row.names = c("s1", "s2")),
  var = data.frame(type = c(1L, 2L), row.names = c("var1", "var2")),
  layers = list(
    spliced = matrix(c(4, 5, 6, 7), nrow = 2),
    unspliced = matrix(c(8, 9, 10, 11), nrow = 2)
  ),
  obsm = list(
    ones = matrix(rep(1L, 10), nrow = 2),
    rand = matrix(rnorm(6), nrow = 2),
    zeros = matrix(rep(0L, 10), nrow = 2)
  ),
  varm = list(
    ones = matrix(rep(1L, 10), nrow = 2),
    rand = matrix(rnorm(6), nrow = 2),
    zeros = matrix(rep(0L, 10), nrow = 2)
  ),
  uns = list(a = 1, b = 2, c = list(c.a = 3, c.b = 4))
)
ad$raw <- ad

library(reticulate)
sc <- import("scanpy")
sc$pp$normalize_per_cell(ad)

ad[]
ad$raw[]
}

## ------------------------------------------------
## Method `RawR6$copy`
## ------------------------------------------------

\dontrun{
ad <- AnnData(
  X = matrix(c(0, 1, 2, 3), nrow = 2)
)
ad$copy()
ad$copy("file.h5ad")
}

## ------------------------------------------------
## Method `RawR6$to_adata`
## ------------------------------------------------

\dontrun{
ad <- AnnData(
  X = matrix(c(0, 1, 2, 3), nrow = 2),
  obs = data.frame(group = c("a", "b"), row.names = c("s1", "s2")),
  var = data.frame(type = c(1L, 2L), row.names = c("var1", "var2")),
  layers = list(
    spliced = matrix(c(4, 5, 6, 7), nrow = 2),
    unspliced = matrix(c(8, 9, 10, 11), nrow = 2)
  )
)
ad$raw <- ad

ad$raw$to_adata()
}

## ------------------------------------------------
## Method `RawR6$print`
## ------------------------------------------------

\dontrun{
ad <- AnnData(
  X = matrix(c(0, 1, 2, 3), nrow = 2),
  obs = data.frame(group = c("a", "b"), row.names = c("s1", "s2")),
  var = data.frame(type = c(1L, 2L), row.names = c("var1", "var2")),
  layers = list(
    spliced = matrix(c(4, 5, 6, 7), nrow = 2),
    unspliced = matrix(c(8, 9, 10, 11), nrow = 2)
  ),
  obsm = list(
    ones = matrix(rep(1L, 10), nrow = 2),
    rand = matrix(rnorm(6), nrow = 2),
    zeros = matrix(rep(0L, 10), nrow = 2)
  ),
  varm = list(
    ones = matrix(rep(1L, 10), nrow = 2),
    rand = matrix(rnorm(6), nrow = 2),
    zeros = matrix(rep(0L, 10), nrow = 2)
  ),
  uns = list(a = 1, b = 2, c = list(c.a = 3, c.b = 4))
)
ad$raw <- ad

library(reticulate)
sc <- import("scanpy")
sc$pp$normalize_per_cell(ad)

ad[]
ad$raw[]

ad$print()
print(ad)
}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{X}}{Data matrix of shape \code{n_obs} × \code{n_vars}.}

\item{\code{n_obs}}{Number of observations.}

\item{\code{obs_names}}{Names of observations.}

\item{\code{n_vars}}{Number of variables.}

\item{\code{var}}{One-dimensional annotation of variables (data.frame).}

\item{\code{var_names}}{Names of variables.}

\item{\code{varm}}{Multi-dimensional annotation of variables (matrix).

Stores for each key a two or higher-dimensional matrix with \code{n_var} rows.}

\item{\code{shape}}{Shape of data matrix (\code{n_obs}, \code{n_vars}).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RawR6-new}{\code{RawR6$new()}}
\item \href{#method-RawR6-copy}{\code{RawR6$copy()}}
\item \href{#method-RawR6-to_adata}{\code{RawR6$to_adata()}}
\item \href{#method-RawR6-print}{\code{RawR6$print()}}
\item \href{#method-RawR6-.set_py_object}{\code{RawR6$.set_py_object()}}
\item \href{#method-RawR6-.get_py_object}{\code{RawR6$.get_py_object()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RawR6-new"></a>}}
\if{latex}{\out{\hypertarget{method-RawR6-new}{}}}
\subsection{Method \code{new()}}{
Create a new Raw object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RawR6$new(obj)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{obj}}{A Python Raw object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RawR6-copy"></a>}}
\if{latex}{\out{\hypertarget{method-RawR6-copy}{}}}
\subsection{Method \code{copy()}}{
Full copy, optionally on disk.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RawR6$copy()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{Path to filename (default: \code{NULL}).}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
ad <- AnnData(
  X = matrix(c(0, 1, 2, 3), nrow = 2)
)
ad$copy()
ad$copy("file.h5ad")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RawR6-to_adata"></a>}}
\if{latex}{\out{\hypertarget{method-RawR6-to_adata}{}}}
\subsection{Method \code{to_adata()}}{
Create a full AnnData object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RawR6$to_adata()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
ad <- AnnData(
  X = matrix(c(0, 1, 2, 3), nrow = 2),
  obs = data.frame(group = c("a", "b"), row.names = c("s1", "s2")),
  var = data.frame(type = c(1L, 2L), row.names = c("var1", "var2")),
  layers = list(
    spliced = matrix(c(4, 5, 6, 7), nrow = 2),
    unspliced = matrix(c(8, 9, 10, 11), nrow = 2)
  )
)
ad$raw <- ad

ad$raw$to_adata()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RawR6-print"></a>}}
\if{latex}{\out{\hypertarget{method-RawR6-print}{}}}
\subsection{Method \code{print()}}{
Print Raw object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RawR6$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{optional arguments to print method.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
ad <- AnnData(
  X = matrix(c(0, 1, 2, 3), nrow = 2),
  obs = data.frame(group = c("a", "b"), row.names = c("s1", "s2")),
  var = data.frame(type = c(1L, 2L), row.names = c("var1", "var2")),
  layers = list(
    spliced = matrix(c(4, 5, 6, 7), nrow = 2),
    unspliced = matrix(c(8, 9, 10, 11), nrow = 2)
  ),
  obsm = list(
    ones = matrix(rep(1L, 10), nrow = 2),
    rand = matrix(rnorm(6), nrow = 2),
    zeros = matrix(rep(0L, 10), nrow = 2)
  ),
  varm = list(
    ones = matrix(rep(1L, 10), nrow = 2),
    rand = matrix(rnorm(6), nrow = 2),
    zeros = matrix(rep(0L, 10), nrow = 2)
  ),
  uns = list(a = 1, b = 2, c = list(c.a = 3, c.b = 4))
)
ad$raw <- ad

library(reticulate)
sc <- import("scanpy")
sc$pp$normalize_per_cell(ad)

ad[]
ad$raw[]

ad$print()
print(ad)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RawR6-.set_py_object"></a>}}
\if{latex}{\out{\hypertarget{method-RawR6-.set_py_object}{}}}
\subsection{Method \code{.set_py_object()}}{
Set internal Python object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RawR6$.set_py_object(obj)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{obj}}{A Python Raw object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RawR6-.get_py_object"></a>}}
\if{latex}{\out{\hypertarget{method-RawR6-.get_py_object}{}}}
\subsection{Method \code{.get_py_object()}}{
Get internal Python object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RawR6$.get_py_object()}\if{html}{\out{</div>}}
}

}
}
