% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/GaussianMF.R
\docType{class}
\name{GaussianMF-class}
\alias{GaussianMF}
\alias{GaussianMF-class}
\title{GaussianMF Membership Function S4 class}
\description{
Represent a concrete GaussianMF shaped Membership Function S4 class with
parameters mu, sigma. Slots inherited of MembershipFunction class and related
functions: show, print, derivateMF, evaluateMF, [ and [<-.
}
\section{Slots}{

\describe{
\item{\code{parameters}}{named numeric vector with parameters of Membership Function.}

\item{\code{nParameters}}{integer with the number of parameters for validity check.}

\item{\code{name}}{character The description of the membership function.}

\item{\code{expression}}{expression object just to display purposes.}
}}
\note{
derivateMF, evaluateMF are extended. Prototype is defined and validity
is inherited.
}
\examples{
#GaussianMF example I
#A Gaussian membership function with default prototype (mu=0, sigma=1)
#The membership of x in the Gaussian, should be 1/sqrt(2*pi) = 0.3989423
#The derivate of the first parameter at x, should be 0
#The derivate on "mu" parameter at x, should be 0
gaussian <- new(Class="GaussianMF")
gaussian
evaluateMF(object=gaussian, x=0)
derivateMF(object=gaussian, x=0, i=1)
derivateMF(object=gaussian, x=0, i="mu")
#
#GaussianMF example II
#A Gaussian membership function with parameters (mu=0, sigma=1)
#The membership of x in the Gaussian, should be 1/sqrt(2*pi) = 0.3989423
#The derivate of the first parameter at x, should be 0
#The derivate on "mu" parameter at x, should be 0
gaussian2 <- new(Class="GaussianMF",parameters=c(mu=0,sigma=1))
gaussian2
evaluateMF(object=gaussian2, x=0)
derivateMF(object=gaussian2, x=0, i=1)
derivateMF(object=gaussian2, x=0, i="mu")
}
\author{
Cristobal Fresno \email{cfresno@bdmg.com.ar}, Andrea S. Llera
 \email{ALlera@leloir.org.ar} and Elmer A. Fernandez
 \email{efernandez@bdmg.com.ar}
}
\seealso{
\code{\link{BellMF-class}} and
 \code{\link{NormalizedGaussianMF-class}}

Other Membership Functions: \code{\link{BellMF}},
  \code{\link{BellMF-class}};
  \code{\link{MembershipFunction}},
  \code{\link{MembershipFunction-class}};
  \code{\link{NormalizedGaussianMF}},
  \code{\link{NormalizedGaussianMF-class}};
  \code{\link{[,MembershipFunction-method}},
  \code{\link{[<-,MembershipFunction-method}},
  \code{\link{extract-methods}},
  \code{\link{extract-methods}}; \code{\link{derivateMF}},
  \code{\link{derivateMF}}, \code{\link{derivateMF}},
  \code{\link{derivateMF}}, \code{\link{derivateMF}},
  \code{\link{derivateMF,BellMF-method}},
  \code{\link{derivateMF,GaussianMF-method}},
  \code{\link{derivateMF,MembershipFunction-method}},
  \code{\link{derivateMF,NormalizedGaussianMF-method}},
  \code{\link{derivateMF-methods}};
  \code{\link{evaluateMF}}, \code{\link{evaluateMF}},
  \code{\link{evaluateMF}}, \code{\link{evaluateMF}},
  \code{\link{evaluateMF}},
  \code{\link{evaluateMF,BellMF-method}},
  \code{\link{evaluateMF,GaussianMF-method}},
  \code{\link{evaluateMF,MembershipFunction-method}},
  \code{\link{evaluateMF,NormalizedGaussianMF-method}},
  \code{\link{evaluateMF-methods}};
  \code{\link{print,MembershipFunction-method}};
  \code{\link{show,MembershipFunction-method}}
}

