% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowmeanV3.R
\name{rowmean}
\alias{rowmean}
\title{Give Column Means of a Matrix-like Object, Based on a Grouping Variable}
\usage{
rowmean(M, group = rownames(M), w = FALSE, reord = FALSE,
  na_rm = FALSE, big = TRUE, ...)
}
\arguments{
\item{M}{a matrix, data frame or vector of numeric data. Missing values are allowed. A numeric vector will be treated as a column vector.}

\item{group}{a vector or factor giving the grouping, with one element per row of M. Default: rownames of M.}

\item{w}{a vector giving the weights that must be applied to each of the stacked blocks of an original object}

\item{reord}{if TRUE, then the result will be in order of sort(unique(group)), if FALSE (the default), it will be in the order that groups were encountered.}

\item{na_rm}{logical (TRUE or FALSE). Should NA (including NaN) values be discarded?}

\item{big}{is your object big and integer overflow is likely? If TRUE, then M is multiplied by 1.0 to ensure values are of type double (perhaps taking more RAM).}

\item{...}{other arguments to be passed to or from methods.}
}
\value{
A matrix-like object containing the means by group. There will be one row per unique value of group.
If object supplied in fact (explicitly) had just one group, base function
\code{colMeans} is called for maximum efficiency and a numeric vector containing
the mean of each column is returned.
}
\description{
Compute column (weighted) means across rows of a numeric matrix-like object for each level of a grouping variable.
}
\details{
This function is a wrapper for base function \code{rowsum} which allows one to compute the (weighted) mean instead of the sum,
while handling integer overflow.

Note: although data frames ara allowed, keep in mind that data frames do not allow duplicate row names. Hence if you have a dataframe with more than 1 group, you may want to use the function as.matrix() to convert it to an object of class matrix

To compute the mean over all the rows of a matrix (i.e. a single group) use colMeans, which should be even faster.
}
\examples{

A <- matrix(1:8, ncol = 2)
rownames(A) <- c("A", "B", "A", "B")
rowmean(A)

B <- matrix(1:40, ncol = 2)
gr <- rep(1:5, 4)
B.mean <- rowmean(B, group = gr)
sum(B.mean[, 1])*4 == sum(B[, 1]) #basic sanity check
sum(B.mean[, 2])*4 == sum(B[, 2]) #basic sanity check

dfB <- as.data.frame(B)
gr <- rep(1:5, 4)
dfB.mean <- rowmean(dfB, group = gr)

numbers <- rnorm(1e7, mean = 3)
C <- matrix(numbers, ncol = 5)
gr <- rep(1:20, 1e5)
rowmean(C, group = gr) # Handles Big Data fast

vec <- 1:10
gr <- rep(1:2, 5)
rowmean(vec, gr)

onegroup = matrix(1:40, ncol = 2)
gr = rep(1,20)
rowmean(onegroup, gr)[1] == mean(onegroup[,1])
rowmean(onegroup, gr)[2] == mean(onegroup[,2])

numbers <- rnorm(30, mean = 3)
D <- matrix(numbers, ncol = 3)
num_blocks <- 2
gr <- rep(1:5, num_blocks)
rownames(D) <- gr
rowmean(D, w = c(0.1,0.9))
rowmean(D, w = c(0,1))
rowmean(D, w = c(0.5,0.5))
rowmean(D)

}
\seealso{
\code{\link[base]{rowsum}}
}
\author{
Albert Dorador
}
