% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_clogit.R
\name{fit_clogit}
\alias{fit_clogit}
\alias{fit_ssf}
\alias{fit_issf}
\title{Fit a conditional logistic regression}
\usage{
fit_clogit(data, formula, more = NULL, summary_only = FALSE, ...)

fit_ssf(data, formula, more = NULL, summary_only = FALSE, ...)

fit_issf(data, formula, more = NULL, summary_only = FALSE, ...)
}
\arguments{
\item{data}{\verb{[data.frame]} \cr The data used to fit a model.}

\item{formula}{\verb{[formula]} \cr The model formula.}

\item{more}{\verb{[list]} \cr Optional list that is passed on the output.}

\item{summary_only}{\verb{[logical(1)=FALSE]} \cr If \code{TRUE} only a \code{broom::tidy} summary of the model is returned.}

\item{...}{Additional arguments, passed to \code{survival::clogit}.}
}
\value{
A list with the following entries
\itemize{
\item model: The model output.
\item sl_: The step length distribution.
\item ta_: The turn angle distribution.
}
}
\description{
This function is a wrapper around \code{survival::clogit}, making it usable in a piped workflow.
}
