% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbox.R
\name{bbox}
\alias{bbox}
\alias{bbox.track_xy}
\alias{bbox.steps_xy}
\title{Get bounding box of a track.}
\usage{
bbox(x, ...)

\method{bbox}{track_xy}(x, spatial = TRUE, buffer = NULL, sf = FALSE,
  ...)

\method{bbox}{steps_xy}(x, spatial = TRUE, buffer = NULL, sf = FALSE,
  ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt]} \cr A track created with \code{make_track}.}

\item{...}{Further arguments, none implemented.}

\item{spatial}{\code{[logical(1)=FALSE]} \cr Whether or not to return a \code{SpatialPolygons}-object or not.}

\item{buffer}{\code{[numeric(0)=NULL]{NULL, >0}} \cr An optional buffer of the bounding box.}

\item{sf}{\code{[logical(1)=FALSE]} \cr If \code{TRUE} a simple feature polygon is returned.}
}
\description{
Get bounding box of a track.
}
\examples{
data(deer)
bbox(deer)
bbox(deer, spatial = FALSE)
bbox(deer, buffer = 100, spatial = FALSE)

# For steps
deer \%>\% steps_by_burst \%>\% bbox(spatial = FALSE)
deer \%>\% steps_by_burst \%>\% bbox(buffer = 100, spatial = FALSE)
deer \%>\% steps_by_burst \%>\% random_steps \%>\% bbox(spatial = FALSE)
}
