% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_covariates.R
\name{calc_gmted}
\alias{calc_gmted}
\title{Calculate elevation covariates}
\usage{
calc_gmted(
  from,
  locs,
  locs_id = NULL,
  radius = 0,
  fun = "mean",
  geom = FALSE,
  ...
)
}
\arguments{
\item{from}{SpatRaster(1). Output from \code{process_gmted()}.}

\item{locs}{data.frame. character to file path, SpatVector, or sf object.}

\item{locs_id}{character(1). Column within \code{locations} CSV file
containing identifier for each unique coordinate location.}

\item{radius}{integer(1). Circular buffer distance around site locations.
(Default = 0).}

\item{fun}{character(1). Function used to summarize multiple raster cells
within sites location buffer (Default = \code{mean}).}

\item{geom}{logical(1). Should the function return a \code{SpatVector}?
Default is \code{FALSE}. The coordinate reference system of the \code{SpatVector} is
that of \code{from.}}

\item{...}{Placeholders}
}
\value{
a data.frame or SpatVector object
}
\description{
Extract elevation values at point locations. Returns a \code{data.frame}
object containing \code{locs_id}, year of release, and elevation variable.
Elevation variable column name reflects the elevation statistic, spatial
resolution of \code{from}, and circular buffer radius (ie. Breakline Emphasis
at 7.5 arc-second resolution with 0 meter buffer: breakline_emphasis_r75_0).
}
\examples{
## NOTE: Example is wrapped in `\dontrun{}` as function requires a large
##       amount of data which is not included in the package.
\dontrun{
loc <- data.frame(id = "001", lon = -78.90, lat = 35.97)
calc_gmted(
  from = gmted, # derived from process_gmted() example
  locs = loc,
  locs_id = "id",
  radius = 0,
  fun = "mean",
  geom = FALSE
)
}
}
\seealso{
\code{\link[=process_gmted]{process_gmted()}}
}
\author{
Mitchell Manware
}
