# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Rho Koenker
#'
#' @param x generic vector
#' @param tau percentile
rho_koenker <- function(x, tau) {
    .Call(`_alqrfe_rho_koenker`, x, tau)
}

#' Loss quantile regression
#'
#' @param beta initial values
#' @param x design matrix
#' @param y vector output
#' @param tau percentile
#' @param N sample size
#' @param d columns of x  
loss_qr <- function(beta, x, y, tau, N, d) {
    .Call(`_alqrfe_loss_qr`, beta, x, y, tau, N, d)
}

#' Loss quantile regression with fixed effects
#'
#' @param theta initial values
#' @param x design matrix
#' @param y vector output
#' @param z incident matrix
#' @param tau percentile
#' @param n N sample size
#' @param d columns of x
#' @param mm n columns of z   
loss_qrfe <- function(theta, x, y, z, tau, n, d, mm) {
    .Call(`_alqrfe_loss_qrfe`, theta, x, y, z, tau, n, d, mm)
}

#' Loss lasso quantile regression with fixed effects
#'
#' @param theta initial values
#' @param x design matrix
#' @param y vector output
#' @param z incident matrix
#' @param tau percentile
#' @param n N sample size
#' @param d columns of x
#' @param mm n columns of z  
#' @param lambda constriction parameter
loss_lqr <- function(theta, x, y, z, tau, n, d, mm, lambda) {
    .Call(`_alqrfe_loss_lqr`, theta, x, y, z, tau, n, d, mm, lambda)
}

#' Loss adaptive lasso quantile regression with fixed effects
#'
#' @param theta initial values
#' @param x design matrix
#' @param y vector output
#' @param z incident matrix
#' @param tau percentile
#' @param n N sample size
#' @param d columns of x
#' @param mm n columns of z  
#' @param lambda constriction parameter
#' @param w weights
loss_alqr <- function(theta, x, y, z, tau, n, d, mm, lambda, w) {
    .Call(`_alqrfe_loss_alqr`, theta, x, y, z, tau, n, d, mm, lambda, w)
}

