% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Taxa.R
\name{Taxon}
\alias{Taxon}
\title{Create a taxonomic hierarchy}
\usage{
Taxon(family = NA_character_, genus = NA_character_, species = NA_character_)
}
\arguments{
\item{family}{The taxonomic family}

\item{genus}{The taxonomic genus}

\item{species}{The taxonomic species}
}
\value{
An instance of class \code{Taxon}
}
\description{
\code{Taxon} represents a taxonomic hierarchy (from family through species). This
class represents a number of validity checks to ensure the taxon is correctly
structured. A taxon must have at least a family specified, and neither genus
nor species can be specified without the "shallower" layers of the hierarchy
specified first. Group \code{Taxon}s together with \code{Taxa()}.
}
\examples{
Taxon(
  family = "Pinaceae",
  genus = "Pinus",
  species = "ponderosa"
)

Taxon(
  family = "Betulaceae"
)
}
