% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aou_concept_set.R
\name{aou_concept_set}
\alias{aou_concept_set}
\title{Get occurrences of a concept set from AoU for a given cohort}
\usage{
aou_concept_set(
  cohort = NULL,
  concepts,
  start_date = NULL,
  end_date = NULL,
  domains = c("condition", "measurement", "observation", "procedure", "drug", "device",
    "visit"),
  output = "indicator",
  concept_set_name = "concept_set",
  min_n = 1,
  con = getOption("aou.default.con"),
  collect = FALSE,
  ...
)
}
\arguments{
\item{cohort}{query to a cohort or local dataframe with a column called "person_id", and (possibly) columns for start_date and end_date.
If not provided, defaults to entire All of Us cohort.}

\item{concepts}{a vector of concept ids}

\item{start_date}{chr; the name of the start_date column in the cohort table; defaults to NULL to pull data across all dates}

\item{end_date}{chr; the name of the end_date column in the cohort table; defaults to NULL to pull data across all dates}

\item{domains}{chr; a vector of domains to search for the concepts in ("condition", "measurement", "observation", "procedure", "drug", "device", "visit"); defaults to all}

\item{output}{one of "indicator", "count", "all"; do you want to return a 1 if a person has any matching concepts and 0 if not ("indicator"),
the number of matching concepts per person ("count"), or all info about the matching concepts ("all"). Defaults to "indicator"}

\item{concept_set_name}{chr; If output = "indicator" or output = "n", name for that column. Defaults to "concept_set".}

\item{min_n}{dbl; If output = "indicator", the minimum number of occurrences per person to consider the indicator true. Defaults to 1.}

\item{con}{connection to the allofus SQL database. Defaults to getOption("aou.default.con"), which is set automatically if you use \code{aou_connect()}}

\item{collect}{lgl; whether to collect from the database}

\item{...}{further arguments passed along to \code{collect()} if \code{collect = TRUE}}
}
\value{
a dataframe if collect = TRUE; a remote tbl if not
}
\description{
Get occurrences of a concept set from AoU for a given cohort
}
\examples{
\dontshow{if (on_workbench()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# indicator for any aspirin at any time
aspirin_users <- aou_concept_set(dplyr::tbl(con, "person"),
  concepts = 1191, concept_set_name = "aspirin", domains = "drug"
)

# starting with person table to create a cohort
people <- dplyr::tbl(con, "person") \%>\%
  dplyr::filter(person_id < 2000000) \%>\%
  dplyr::mutate(
    start = as.Date("2021-01-01"),
    end = as.Date("2023-12-31")
  )

dat <- aou_concept_set(
  cohort = people,
  concepts = c(725115, 1612146, 1613031),
  start_date = "start",
  end_date = "end",
  concept_set_name = "CGM",
  output = "all"
)
\dontshow{\}) # examplesIf}
}
