% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyto_ts_aggregate.r
\name{phyto_ts_aggregate}
\alias{phyto_ts_aggregate}
\title{Aggregate phytoplankton timeseries based on abundance. Up to 3 grouping variables can be given:
e.g. genus, species, stationid, depth range.
If no abundance var is given, will aggregate to presence/absence of grouping vars.}
\usage{
phyto_ts_aggregate(
  phyto.data,
  DateVar = "date_dd_mm_yy",
  SummaryType = c("abundance", "presence.absence"),
  AbundanceVar = "biovol_um3_ml",
  GroupingVar1 = "phyto_name",
  GroupingVar2 = NA,
  GroupingVar3 = NA,
  remove.rare = FALSE,
  fun = sum,
  format = "\%d-\%m-\%y"
)
}
\arguments{
\item{phyto.data}{data.frame}

\item{DateVar}{character string: field name for date variable. character or POSIX data.}

\item{SummaryType}{'abundance' for a matrix of aggregated abundance,'presence.absence'
for 1 (present) and 0 (absent).}

\item{AbundanceVar}{character string with field name containing abundance data
Can be NA if data is only a species list and aggregated presence/absence is desired.}

\item{GroupingVar1}{character string: field name for first grouping variable. defaults to spp.}

\item{GroupingVar2}{character string: name of additional grouping var field}

\item{GroupingVar3}{character string: name of additional grouping var field}

\item{remove.rare}{TRUE/FALSE. If TRUE, removes all instances of GroupingVar1 that occur < 5%
of time periods.}

\item{fun}{function used to aggregate abundance based on grouping variables}

\item{format}{character string: format for DateVar POSIXct conversion}
}
\value{
a data.frame with grouping vars, date_dd_mm_yy, and abundance or presence/absence
}
\description{
Aggregate phytoplankton timeseries based on abundance. Up to 3 grouping variables can be given:
e.g. genus, species, stationid, depth range.
If no abundance var is given, will aggregate to presence/absence of grouping vars.
}
\examples{
data(lakegeneva)
lakegeneva<-genus_species_extract(lakegeneva,'phyto_name')
lg.genera=phyto_ts_aggregate(lakegeneva,SummaryType='presence.absence',
                             GroupingVar1='genus')
head(lg.genera)
}
