% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgentLookMode.R
\docType{data}
\name{AgentLookMode}
\alias{AgentLookMode}
\title{Agent look modes.}
\format{
An object of class \code{list} of length 12.
}
\usage{
AgentLookMode
}
\value{
A list of numbers representing each agent look mode
}
\description{
These are meant to be used to indicate what kind of look function
the agents use to look around and decide where to go next. Possible values:
\itemize{
  \item{AgentLookMode$None}
  \item{AgentLookMode$Standard}
  \item{AgentLookMode$LineOfSightLength}
  \item{AgentLookMode$OcclusionLength}
  \item{AgentLookMode$OcclusionAny}
  \item{AgentLookMode$OcclusionGroup45 (Occlusion group bins - 45 degrees)}
  \item{AgentLookMode$OcclusionGroup60 (Occlusion group bins - 60 degrees)}
  \item{AgentLookMode$OcclusionFurthest (Furthest occlusion per bin)}
  \item{AgentLookMode$BinFarDistance (Per bin far distance weighted)}
  \item{AgentLookMode$BinAngle (Per bin angle weighted)}
  \item{AgentLookMode$BinFarDistanceAngle (Per bin far-distance and angle
  weighted)}
  \item{AgentLookMode$BinMemory (Per bin memory)}
}
}
\examples{
AgentLookMode$Standard
AgentLookMode$LineOfSightLength
AgentLookMode$OcclusionAny
}
\keyword{datasets}
