% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allToAllTraverse.R
\name{vgaVisualLocal}
\alias{vgaVisualLocal}
\title{Visibility Graph Analysis - Visual local metrics}
\usage{
vgaVisualLocal(pointMap, copyMap = TRUE, gatesOnly = FALSE)
}
\arguments{
\item{pointMap}{A PointMap}

\item{copyMap}{Optional. Copy the internal sala map}

\item{gatesOnly}{Optional. Only keep the values at specific gates}
}
\value{
A new PointMap with the results included
}
\description{
Runs Visibility Graph Analysis to get visual local metrics
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "simple",
    "simple_interior.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  pointMap <- makeVGAPointMap(
    sfMap,
    gridSize = 0.5,
    fillX = 3.0,
    fillY = 6.0,
    maxVisibility = NA,
    boundaryGraph = FALSE,
    verbose = FALSE
  )
vgaVisualLocal(pointMap, FALSE)
}
