% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity.R
\name{countClones}
\alias{countClones}
\title{Tabulates clones sizes}
\usage{
countClones(data, groups = NULL, copy = NULL, clone = "CLONE")
}
\arguments{
\item{data}{data.frame with Change-O style columns containing clonal assignments.}

\item{groups}{character vector defining \code{data} columns containing grouping 
variables. If \code{group=NULL}, then do not group data.}

\item{copy}{name of the \code{data} column containing copy numbers for each 
sequence. If this value is specified, then total copy abundance
is determined by the sum of copy numbers within each clonal group.}

\item{clone}{name of the \code{data} column containing clone identifiers.}
}
\value{
A data.frame summarizing clone counts and frequencies with columns:
          \itemize{
            \item \code{CLONE}:       clone identifier.
            \item \code{SEQ_COUNT}:   total number of sequences for the clone.
            \item \code{SEQ_FREQ}:    frequency of the clone as a fraction of the total
                                      number of sequences within each group.
            \item \code{COPY_COUNT}:  sum of the copy counts in the \code{copy} column.
                                      Only present if the \code{copy} argument is 
                                      specified.
            \item \code{COPY_FREQ}:   frequency of the clone as a fraction of the total
                                      copy number within each group. Only present if 
                                      the \code{copy} argument is specified.
          }
          Also includes additional columns specified in the \code{groups} argument.
}
\description{
\code{countClones} determines the number of sequences and total copy number of 
clonal groups.
}
\examples{
# Without copy numbers
clones <- countClones(ExampleDb, groups="SAMPLE")

# With copy numbers and multiple groups
clones <- countClones(ExampleDb, groups=c("SAMPLE", "ISOTYPE"), copy="DUPCOUNT")

}

