# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

validChars <- function(seq1, seq2) {
    .Call('alakazam_validChars', PACKAGE = 'alakazam', seq1, seq2)
}

#' Test DNA sequences for equality.
#' 
#' \code{seqEqual} checks if two DNA sequences are identical.
#'
#' @param    seq1    character string containing a DNA sequence.
#' @param    seq2    character string containing a DNA sequence.
#' @param    ignore  vector of characters to ignore when testing for equality.
#' 
#' @return   Returns \code{TRUE} if sequences are equal and \code{FALSE} if they are not.
#'           Sequences of unequal length will always return \code{FALSE} regardless of
#'           their character values.
#' 
#' @seealso  Used by \link{pairwiseEqual} within \link{collapseDuplicates}.
#'           See \link{seqDist} for calculation Hamming distances between sequences.
#' 
#' @examples
#' # Ignore gaps
#' seqEqual("ATG-C", "AT--C")
#' seqEqual("ATGGC", "ATGGN")
#' seqEqual("AT--T", "ATGGC")
#' 
#' # Ignore only Ns
#' seqEqual("ATG-C", "AT--C", ignore="N")
#' seqEqual("ATGGC", "ATGGN", ignore="N")
#' seqEqual("AT--T", "ATGGC", ignore="N")
#' 
#' @export
seqEqual <- function(seq1, seq2, ignore = character()) {
    .Call('alakazam_seqEqual', PACKAGE = 'alakazam', seq1, seq2, ignore)
}

#' Calculate pairwise equivalence between sequences
#' 
#' \code{pairwiseEqual} determined pairwise equivalence between a pairs in a 
#' set of sequences, excluding ambiguous positions (Ns and gaps).
#'
#' @param    seq  character vector containing a DNA sequences.
#'
#' @return   A logical matrix of equivalence between each entry in \code{seq}. 
#'           Values are \code{TRUE} when sequences are equivalent and \code{FALSE}
#'           when they are not.
#' 
#' @seealso  Uses \link{seqEqual} for testing equivalence between pairs.
#'           See \link{pairwiseDist} for generating a sequence distance matrix.
#'           
#' @examples
#' # Gaps and Ns will match any character
#' seq <- c(A="ATGGC", B="ATGGG", C="ATGGG", D="AT--C", E="NTGGG")
#' d <- pairwiseEqual(seq)
#' rownames(d) <- colnames(d) <- seq
#' d
#' 
#' @export
pairwiseEqual <- function(seq) {
    .Call('alakazam_pairwiseEqual', PACKAGE = 'alakazam', seq)
}

seqDistRcpp <- function(seq1, seq2, dist_mat) {
    .Call('alakazam_seqDistRcpp', PACKAGE = 'alakazam', seq1, seq2, dist_mat)
}

pairwiseDistRcpp <- function(seq, dist_mat) {
    .Call('alakazam_pairwiseDistRcpp', PACKAGE = 'alakazam', seq, dist_mat)
}

