% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sequence.R
\name{getSeqDistance}
\alias{getSeqDistance}
\title{Calculate distance between two sequences}
\usage{
getSeqDistance(seq1, seq2, dist_mat = getDNAMatrix(gap = -1))
}
\arguments{
\item{seq1}{character string containing a DNA sequence.}

\item{seq2}{character string containing a DNA sequence.}

\item{dist_mat}{Character distance matrix. Defaults to a Hamming distance 
matrix returned by \code{\link{getDNAMatrix}}. If gap 
characters, \code{c("-", ".")}, are assigned a value of -1 
in \code{dist_mat} then contiguous gaps of any run length,
which are not present in both sequences, will be counted as a 
distance of 1. Meaning, indels of any length will increase
the sequence distance by 1. Gap values other than -1 will 
return a distance that does not consider indels as a special case.}
}
\value{
Numerical distance between \code{seq1} and \code{seq2}.
}
\description{
\code{getSeqDistance} calculates the distance between two DNA sequences.
}
\examples{
# Ungapped examples
getSeqDistance("ATGGC", "ATGGG")
getSeqDistance("ATGGC", "ATG??")

# Gaps will be treated as Ns with a gap=0 distance matrix
getSeqDistance("ATGGC", "AT--C", dist_mat=getDNAMatrix(gap=0))

# Gaps will be treated as universally non-matching characters with gap=1
getSeqDistance("ATGGC", "AT--C", dist_mat=getDNAMatrix(gap=1))

# Gaps of any length will be treated as single mismatches with a gap=-1 distance matrix
getSeqDistance("ATGGC", "AT--C", dist_mat=getDNAMatrix(gap=-1))

# Gaps of equivalent run lengths are not counted as gaps
getSeqDistance("ATG-C", "ATG-C", dist_mat=getDNAMatrix(gap=-1))

# Overlapping runs of gap characters are counted as a single gap
getSeqDistance("ATG-C", "AT--C", dist_mat=getDNAMatrix(gap=-1))
getSeqDistance("A-GGC", "AT--C", dist_mat=getDNAMatrix(gap=-1))
getSeqDistance("AT--C", "AT--C", dist_mat=getDNAMatrix(gap=-1))

# Discontiguous runs of gap characters each count as separate gaps
getSeqDistance("-TGGC", "AT--C", dist_mat=getDNAMatrix(gap=-1))

}
\seealso{
Nucleotide distance matrix may be built with 
          \code{\link{getDNAMatrix}}. Amino acid distance matrix may be built
          with \code{\link{getAAMatrix}}.
}

